/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.engine.bridges.mthread.ClockedAsynchronousQueue;
import ch.tachyon.tunnel.engine.bridges.mthread.MtBase;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPullEffect;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.utils.concurrent.Task;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MtScPull
extends MtBase<IPullEffect>
implements IPullEffect,
ISingleChanAudioSource {
    volatile boolean active = false;
    boolean started = false;
    private ISingleChanAudioSource source;
    private int length;
    private SourceTask[] taskSources;
    private float[][] buffers;
    private int taskIndex;
    ClockedAsynchronousQueue<float[]> queue;
    private AtomicLong producerClock = new AtomicLong();
    private long consumerClock;
    private float[] curBuffer;
    private int srcIndex;

    public MtScPull(IPullEffect target, MtContext mtContext) {
        super(target, true, mtContext);
        if (!mtContext.isMultiCore()) {
            throw new IllegalStateException("MtScPull not supported when only one CPU core is used");
        }
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IPullEffect)this.getBaseTarget()).canWriteFasterThanRead();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        int capacity = this.mtContext.getSerialRunningMaxSkew();
        this.queue = new ClockedAsynchronousQueue(capacity);
        this.curBuffer = null;
        this.srcIndex = 0;
        this.producerClock.set(0L);
        this.consumerClock = 0L;
        this.length = -1;
        if (this.getBaseTarget() instanceof IFixedChunkLength) {
            this.length = ((IFixedChunkLength)this.getBaseTarget()).getFixedChunkLength();
        }
        this.active = true;
        this.started = false;
        this.taskSources = new SourceTask[super.getInputPoolSize(false) + 1];
        int i = 0;
        while (i < this.taskSources.length) {
            this.taskSources[i] = new SourceTask();
            ++i;
        }
        this.taskIndex = 0;
    }

    @Override
    public int process(ISingleChanAudioSource source, float[] output) {
        this.source = source;
        if (!this.started && this.active) {
            this.started = true;
            if (this.length <= 0) {
                this.length = output.length;
            }
            this.buffers = new float[this.taskSources.length][this.length];
            this.threadPool.addTaskFactory(new Task(){

                public void run() {
                    if (MtScPull.this.active) {
                        MtScPull.this.submitNextTask();
                    } else {
                        MtScPull.this.threadPool.removeSelfTaskFactory();
                    }
                }
            });
        }
        int dstIndex = 0;
        while (dstIndex < output.length) {
            int amount;
            if (this.curBuffer == null || this.srcIndex >= this.curBuffer.length) {
                if (this.curBuffer != null && this.curBuffer.length < this.length) {
                    while (this.consumerClock < this.producerClock.get()) {
                        float[] end = this.queue.take(this.consumerClock++);
                        assert (end.length == 0) : "Buffer of length " + end.length + " received after EOF";
                    }
                    break;
                }
                this.curBuffer = this.queue.take(this.consumerClock++);
                this.srcIndex = 0;
            }
            if ((amount = Math.min(output.length - dstIndex, this.curBuffer.length - this.srcIndex)) > 0) {
                System.arraycopy(this.curBuffer, this.srcIndex, output, dstIndex, amount);
            }
            this.srcIndex += amount;
            dstIndex += amount;
        }
        return dstIndex;
    }

    private void submitNextTask() {
        SourceTask task = this.taskSources[this.taskIndex];
        float[] buffer = this.buffers[this.taskIndex];
        task.init(this.producerClock.getAndIncrement(), buffer);
        this.taskIndex = (this.taskIndex + 1) % this.taskSources.length;
        this.threadPool.submitAsync(task);
    }

    @Override
    public void stopProcessing() {
        if (this.active) {
            int amount;
            this.active = false;
            while ((amount = this.process(this, new float[this.length])) == this.length) {
            }
        }
        super.stopProcessing();
        this.source = null;
        this.queue = null;
        this.curBuffer = null;
        this.taskSources = null;
        this.buffers = null;
    }

    @Override
    public int readSamples(float[] target) {
        this.readSection.enterSerialSection();
        try {
            if (!this.active) {
                return 0;
            }
            int result = this.source.readSamples(target);
            if (result < target.length) {
                this.active = false;
            }
            int n = result;
            return n;
        }
        finally {
            this.readSection.leaveSerialSection();
        }
    }

    class SourceTask
    extends Task {
        private long taskClock;
        private float[] output;

        SourceTask() {
        }

        void init(long taskClock, float[] buffer) {
            this.taskClock = taskClock;
            this.output = buffer;
        }

        public void run() {
            ISerialSectionExt serialSection;
            ISerialSectionExt[] iSerialSectionExtArray = MtScPull.this.serialSections;
            int n = MtScPull.this.serialSections.length;
            int n2 = 0;
            while (n2 < n) {
                serialSection = iSerialSectionExtArray[n2];
                serialSection.setActive(true);
                serialSection.setClock(this.taskClock);
                ++n2;
            }
            assert (MtScPull.this.serialAccus.length == 0);
            if (MtScPull.this.active) {
                IPullEffect plugin = (IPullEffect)MtScPull.super.getProcessingTarget(Thread.currentThread());
                int amount = plugin.process(MtScPull.this, this.output);
                if (amount < this.output.length) {
                    float[] tmp = this.output;
                    this.output = new float[amount];
                    System.arraycopy(tmp, 0, this.output, 0, amount);
                }
                MtScPull.this.queue.put(this.taskClock, this.output);
                MtScPull.this.framesCounter.addAndGet(amount);
            } else {
                MtScPull.this.queue.put(this.taskClock, new float[0]);
            }
            MtScPull.this.writeSection.sync();
            iSerialSectionExtArray = MtScPull.this.serialSections;
            n = MtScPull.this.serialSections.length;
            n2 = 0;
            while (n2 < n) {
                serialSection = iSerialSectionExtArray[n2];
                serialSection.setActive(false);
                ++n2;
            }
        }
    }
}

