/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.engine.bridges.mthread.MtBase;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.utils.concurrent.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MtScPush
extends MtBase<IPushEffect>
implements IPushEffect {
    private float[][] buffers;
    private int bufferIndex;
    private TaskSink[] taskSinks;
    private int taskIndex;
    private long clock;
    private AtomicInteger nbTasks = new AtomicInteger();
    private volatile Thread completionWaiter = null;

    public MtScPush(IPushEffect target, MtContext mtContext) {
        super(target, false, mtContext);
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IPushEffect)this.getBaseTarget()).canWriteFasterThanRead();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        boolean accuMode = this.serialAccus.length > 0;
        this.buffers = null;
        this.taskSinks = new TaskSink[super.getInputPoolSize(accuMode) + 1];
        int i = 0;
        while (i < this.taskSinks.length) {
            this.taskSinks[i] = accuMode ? new TaskSinkAccu() : new TaskSinkSerial();
            ++i;
        }
        this.clock = 0L;
    }

    @Override
    public void process(float[] input0, int length, ISingleChanAudioSink sink) {
        if (this.buffers == null) {
            int mult = 1;
            if (this.pluginFixedSize > 0 && this.historySize > 0) {
                mult = (this.historySize + input0.length) / this.pluginFixedSize;
            }
            this.buffers = new float[this.getInputPoolSize(this.serialAccus.length > 0) * mult + 1][];
        }
        float[] input = this.getNextBuffer(input0.length);
        assert (input.length >= input0.length);
        System.arraycopy(input0, 0, input, 0, input0.length);
        this.submitChunk(sink, input0.length, input, length < input0.length, length + this.historySize, this.historySize);
    }

    private float[] getNextBuffer(int length) {
        int bufSize;
        float[] input = this.buffers[this.bufferIndex];
        int n = bufSize = this.pluginFixedSize > 0 ? this.pluginFixedSize : length + this.historySize;
        if (input == null || input.length != bufSize) {
            input = new float[bufSize];
            this.buffers[this.bufferIndex] = input;
        }
        this.bufferIndex = (this.bufferIndex + 1) % this.buffers.length;
        return input;
    }

    private void submitChunk(ISingleChanAudioSink sink, int baseInputLength, float[] input, boolean isLast, int chunkLength, int crop) {
        TaskSink task = this.taskSinks[this.taskIndex];
        this.taskIndex = (this.taskIndex + 1) % this.taskSinks.length;
        task.init(baseInputLength, input, chunkLength, crop, this.clock++, sink);
        if (this.serialize) {
            task.run();
        } else {
            this.started();
            this.threadPool.submitFragment(task);
            if (isLast) {
                this.waitCompletion();
            }
        }
    }

    void started() {
        this.nbTasks.incrementAndGet();
    }

    void completed() {
        int newValue = this.nbTasks.decrementAndGet();
        Thread waiter = this.completionWaiter;
        if (newValue == 0 && waiter != null) {
            LockSupport.unpark(waiter);
        }
    }

    private void waitCompletion() {
        this.completionWaiter = Thread.currentThread();
        while (this.nbTasks.get() > 0) {
            LockSupport.park();
        }
        this.completionWaiter = null;
    }

    @Override
    public void stopProcessing() {
        this.waitCompletion();
        super.stopProcessing();
        Arrays.fill(this.taskSinks, null);
    }

    abstract class TaskSink
    extends Task
    implements ISingleChanAudioSink {
        TaskSink() {
        }

        public abstract void init(int var1, float[] var2, int var3, int var4, long var5, ISingleChanAudioSink var7);
    }

    class TaskSinkAccu
    extends TaskSink {
        private float[] input;
        private int length;
        private long clock;
        private ISingleChanAudioSink sink;

        TaskSinkAccu() {
        }

        public void init(int baseInputLength, float[] input, int length, int historySizeToCrop, long clock, ISingleChanAudioSink sink) {
            this.input = input;
            this.length = length;
            this.clock = clock;
            this.sink = sink;
        }

        public void run() {
            Object[] objectArray = MtScPush.this.serialSections;
            int n = MtScPush.this.serialSections.length;
            int n2 = 0;
            while (n2 < n) {
                ISerialSectionExt serialSection = objectArray[n2];
                serialSection.setActive(true);
                serialSection.setClock(this.clock);
                ++n2;
            }
            objectArray = MtScPush.this.serialAccus;
            n = MtScPush.this.serialAccus.length;
            n2 = 0;
            while (n2 < n) {
                Object serialAccu = objectArray[n2];
                serialAccu.setActive(true);
                serialAccu.setClock(this.clock);
                ++n2;
            }
            IPushEffect plugin = (IPushEffect)MtScPush.super.getProcessingTarget(Thread.currentThread());
            plugin.process(this.input, this.length, this);
            MtScPush.this.completed();
            Object[] objectArray2 = MtScPush.this.serialSections;
            int n3 = MtScPush.this.serialSections.length;
            n = 0;
            while (n < n3) {
                ISerialSectionExt serialSection = objectArray2[n];
                serialSection.setActive(false);
                ++n;
            }
            objectArray2 = MtScPush.this.serialAccus;
            n3 = MtScPush.this.serialAccus.length;
            n = 0;
            while (n < n3) {
                Object serialAccu = objectArray2[n];
                serialAccu.setActive(false);
                ++n;
            }
        }

        public void writeSamples(float[] samples) {
            this.sink.writeSamples(samples);
        }
    }

    class TaskSinkSerial
    extends TaskSink {
        private int baseInputLength;
        private float[] input;
        private int length;
        private long clock;
        private int historySizeToCrop;
        private ISingleChanAudioSink sink;
        private final List<float[]> outputs = new ArrayList<float[]>();

        TaskSinkSerial() {
        }

        public void init(int baseInputLength, float[] input, int length, int historySizeToCrop, long clock, ISingleChanAudioSink sink) {
            this.baseInputLength = baseInputLength;
            this.input = input;
            this.length = length;
            this.clock = clock;
            this.sink = sink;
            this.outputs.clear();
            this.historySizeToCrop = historySizeToCrop;
        }

        public void run() {
            IPushEffect plugin;
            ISerialSectionExt[] iSerialSectionExtArray = MtScPush.this.serialSections;
            int n = MtScPush.this.serialSections.length;
            int n2 = 0;
            while (n2 < n) {
                ISerialSectionExt serialSection = iSerialSectionExtArray[n2];
                serialSection.setActive(true);
                serialSection.setClock(this.clock);
                ++n2;
            }
            assert (MtScPush.this.serialAccus.length == 0);
            if (this.historySizeToCrop > 0) {
                MtScPush.this.historyBuffer.write(this.input, this.baseInputLength, this.clock * (long)this.baseInputLength);
                MtScPush.this.historySection.sync();
                MtScPush.this.historyBuffer.read(-this.historySizeToCrop, this.input, this.clock * (long)this.baseInputLength);
            }
            if ((plugin = (IPushEffect)MtScPush.super.getProcessingTarget(Thread.currentThread())) == null) {
                assert (MtScPush.this.serialize);
                plugin = (IPushEffect)MtScPush.this.getBaseTarget();
            }
            plugin.process(this.input, this.length, this);
            MtScPush.this.writeSection.enterSerialSection();
            try {
                for (float[] output : this.outputs) {
                    if (this.historySizeToCrop > output.length) {
                        this.historySizeToCrop -= output.length;
                        continue;
                    }
                    if (this.historySizeToCrop > 0) {
                        int croppedLength = output.length - this.historySizeToCrop;
                        float[] cropped = new float[croppedLength];
                        System.arraycopy(output, output.length - croppedLength, cropped, 0, croppedLength);
                        this.sink.writeSamples(cropped);
                        continue;
                    }
                    this.sink.writeSamples(output);
                }
            }
            finally {
                MtScPush.this.writeSection.leaveSerialSection();
            }
            MtScPush.this.framesCounter.addAndGet(this.length - this.historySizeToCrop);
            MtScPush.this.completed();
            ISerialSectionExt[] iSerialSectionExtArray2 = MtScPush.this.serialSections;
            int n3 = MtScPush.this.serialSections.length;
            int n4 = 0;
            while (n4 < n3) {
                ISerialSectionExt serialSection = iSerialSectionExtArray2[n4];
                serialSection.setActive(false);
                ++n4;
            }
        }

        public void writeSamples(float[] samples) {
            this.outputs.add(samples);
        }
    }
}

