/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialAccumulator;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialSectionPool
implements ISerialSectionPool {
    private final IMtContext mtContext;
    private final Map<String, ISerialSection> serialSections = new LinkedHashMap<String, ISerialSection>();
    private final Map<String, ISerialAccumulator<?>> serialAccus = new LinkedHashMap();
    private int threadIndex;

    public SerialSectionPool(IMtContext mtContext) {
        this.mtContext = mtContext;
    }

    @Override
    public ISerialSection getSerialSection(String name) {
        return this.serialSections.get(name);
    }

    @Override
    public <E> ISerialAccumulator<E> getSerialAccu(String name, Class<E> workType) {
        ISerialAccumulator<?> result = this.serialAccus.get(name);
        return result;
    }

    public void addSerialSection(String name, ISerialSection serialSection) {
        if (this.serialSections.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate serial section name " + name);
        }
        this.serialSections.put(name, serialSection);
    }

    public void addSerialAccu(String name, ISerialAccumulator<?> serialAccu) {
        if (this.serialAccus.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate serial accumulator name " + name);
        }
        this.serialAccus.put(name, serialAccu);
    }

    public boolean hasSerialAccumulators() {
        return !this.serialAccus.isEmpty();
    }

    public Collection<ISerialSection> getSerialSections() {
        return this.serialSections.values();
    }

    public Collection<ISerialAccumulator<?>> getSerialAccus() {
        return this.serialAccus.values();
    }

    public int getNbSerialSections() {
        return this.serialSections.size();
    }

    public int getNbSerialAccus() {
        return this.serialAccus.size();
    }

    void setThreadIndex(int threadIndex) {
        this.threadIndex = threadIndex;
    }

    @Override
    public int getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public IMtContext getMtContext() {
        return this.mtContext;
    }
}

