/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread.old;

import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.engine.utils.PluginDuplicator;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.ILoadUnload;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.thread.IMultiStep;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.numa.SerialTask;
import ch.tachyon.tunnel.utils.numa.Task0;
import ch.tachyon.tunnel.utils.numa.ThreadPool0;
import ch.tachyon.tunnel.utils.old.ConcurrentSerialSection;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumaScPush<E extends IPushEffect>
implements IPushEffect,
IStartStop {
    private final E target;
    private ConcurrentSerialSection writeSection;
    private List<E> poolPlugins;
    private List<Task0[]> poolTasks;
    private int poolIndex;
    private float[][] buffers;
    private int bufferIndex;
    private int minInputHistorySize = 0;
    private long clock = 0L;
    public static AtomicInteger nbQueued = new AtomicInteger(0);
    public static AtomicInteger maxQueued = new AtomicInteger(0);

    public NumaScPush(E target) {
        if (!(target instanceof IMultiStep)) {
            throw new ClassCastException("Target does not implement IMultiStep");
        }
        this.target = target;
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return this.target.canWriteFasterThanRead();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        this.setupPool(this.target, info);
        this.minInputHistorySize = ((IMultiStep)this.target).getMinInputHistorySize();
        this.buffers = new float[this.getInputPoolSize()][];
        this.bufferIndex = 0;
        this.clock = 0L;
    }

    private int getInputPoolSize() {
        return ThreadPool0.getMaxSkew() + this.minInputHistorySize;
    }

    private void setupPool(E plugin, IProcessingInfo info) {
        BitSet serialSteps = ((IMultiStep)plugin).getSerialSteps();
        ConcurrentSerialSection[] serialSections = new ConcurrentSerialSection[serialSteps.cardinality()];
        int i = 0;
        while (i < serialSections.length) {
            serialSections[i] = new ConcurrentSerialSection("Section " + i);
            ++i;
        }
        HashMap<String, Object> sharedMap = new HashMap<String, Object>();
        int maxQueue = Math.max(ThreadPool0.getIncommingQueueCapacity(), Math.max(ThreadPool0.getFrontQueueCapacity(), ThreadPool0.getSerialQueueCapacity()));
        int poolSize = ThreadPool0.getMaxSkew() + maxQueue;
        Debug.info("poolSize: {0}", poolSize);
        this.poolPlugins = new CopyOnWriteArrayList();
        this.poolTasks = new CopyOnWriteArrayList<Task0[]>();
        int index = 0;
        while (index < poolSize) {
            Object poolPlugin;
            if (index == 0) {
                poolPlugin = plugin;
                if (plugin instanceof IStartStop) {
                    ((IStartStop)plugin).startProcessing(info);
                }
            } else {
                poolPlugin = (IPushEffect)PluginDuplicator.prepareCopy(plugin, info);
                if (poolPlugin instanceof IStartStop && !(poolPlugin instanceof Cloneable)) {
                    ((IStartStop)poolPlugin).startProcessing(info);
                }
            }
            ((IMultiStep)poolPlugin).setupCommonData(sharedMap);
            this.poolPlugins.add(poolPlugin);
            Runnable[] steps = ((IMultiStep)poolPlugin).getAdditionalSteps();
            Task0[] tasks = new Task0[steps.length];
            int ssIndex = 0;
            int i2 = 0;
            while (i2 < steps.length) {
                Task0 task;
                final Runnable runnable = steps[i2];
                if (serialSteps.get(i2)) {
                    ConcurrentSerialSection ss = serialSections[ssIndex++];
                    task = new SerialTask("Step[" + i2 + "] " + index, ss){

                        public void run() {
                            runnable.run();
                        }
                    };
                } else {
                    task = new Task0("Step[" + i2 + "] " + index){

                        public void run() {
                            runnable.run();
                        }
                    };
                }
                tasks[i2] = task;
                ++i2;
            }
            this.poolTasks.add(tasks);
            ++index;
            ++index;
        }
        this.poolIndex = 0;
        this.writeSection = new ConcurrentSerialSection("Sink section");
    }

    @Override
    public void process(float[] input0, int length, ISingleChanAudioSink sink) {
        float[] input = this.buffers[this.bufferIndex];
        if (input == null || input.length != input0.length) {
            input = new float[input0.length];
            this.buffers[this.bufferIndex] = input;
        }
        this.bufferIndex = (this.bufferIndex + 1) % this.buffers.length;
        System.arraycopy(input0, 0, input, 0, input0.length);
        int myIndex = this.poolIndex;
        this.poolIndex = (this.poolIndex + 1) % this.poolPlugins.size();
        CountDownLatch completion = null;
        if (length < input.length) {
            completion = new CountDownLatch(1);
        }
        SinkTask sinkTask = new SinkTask(this.writeSection, sink, completion);
        sinkTask.setClock(this.clock++);
        SourceTask sourceTask = new SourceTask(myIndex, input, length, sinkTask);
        int newValue = nbQueued.incrementAndGet();
        maxQueued.compareAndSet(newValue - 1, newValue);
        ThreadPool0.submitFirst(sourceTask);
        if (completion != null) {
            try {
                completion.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void stopProcessing() {
        this.flushPool(this.target);
    }

    private void flushPool(E main) {
        for (IPushEffect plugin : this.poolPlugins) {
            if (!(plugin instanceof IStartStop)) continue;
            ((IStartStop)((Object)plugin)).stopProcessing();
        }
        for (IPushEffect plugin : this.poolPlugins) {
            if (plugin == main || !(plugin instanceof ILoadUnload)) continue;
            ((ILoadUnload)((Object)plugin)).unload();
        }
        this.poolPlugins.clear();
        this.poolTasks.clear();
    }

    static class SinkTask
    extends SerialTask
    implements ISingleChanAudioSink {
        private final List<float[]> outputs = new ArrayList<float[]>();
        private final ISingleChanAudioSink sink;
        private final CountDownLatch completion;

        public SinkTask(ConcurrentSerialSection serialSection, ISingleChanAudioSink sink, CountDownLatch completion) {
            super("Sink", serialSection);
            this.sink = sink;
            this.completion = completion;
        }

        public void run() {
            for (float[] output : this.outputs) {
                this.sink.writeSamples(output);
            }
            if (this.completion != null) {
                this.completion.countDown();
            }
            nbQueued.decrementAndGet();
        }

        public void writeSamples(float[] samples) {
            this.outputs.add(samples);
        }
    }

    class SourceTask
    extends Task0 {
        private final int poolIndex;
        private final float[] input;
        private final int length;
        private final SinkTask sink;

        public SourceTask(int poolIndex, float[] input, int length, SinkTask sink) {
            super("Source " + poolIndex);
            this.poolIndex = poolIndex;
            this.input = input;
            this.length = length;
            this.sink = sink;
        }

        public void run() {
            IPushEffect plugin = (IPushEffect)NumaScPush.this.poolPlugins.get(this.poolIndex);
            plugin.process(this.input, this.length, this.sink);
            Task0[] tasks = (Task0[])NumaScPush.this.poolTasks.get(this.poolIndex);
            this.setNextTask(tasks[0]);
            long clock = this.sink.getClock();
            int i = 0;
            while (i < tasks.length) {
                if (i < tasks.length - 1) {
                    tasks[i].setNextTask(tasks[i + 1]);
                } else {
                    tasks[i].setNextTask(this.sink);
                }
                if (tasks[i] instanceof SerialTask) {
                    ((SerialTask)tasks[i]).setClock(clock);
                }
                ++i;
            }
        }
    }
}

