/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread.serial;

import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialAccumulatorEx;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugSerialAccumulator<E>
implements ISerialAccumulatorEx<E> {
    private final String name;
    private final Object userData;
    private int capacity;
    private final Object nextClock = new Monitor("nextClock");
    private final AtomicInteger nbWaiters = new AtomicInteger();
    private AtomicReferenceArray<ClockedWork<E>> waitQueue;
    private final AtomicLong clock = new AtomicLong(0L);
    private final ThreadLocal<Long> threadClock = new ThreadLocal();
    private final ThreadLocal<Boolean> active = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final ThreadLocal<Boolean> firstEnter = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    private static final ThreadLocal<Boolean> firstAccu = new ThreadLocal();
    private final AtomicBoolean entered = new AtomicBoolean(false);
    private static final ThreadLocal<DebugSerialAccumulator<?>> previousAccu = new ThreadLocal();
    private DebugSerialAccumulator<?> commonPreviousAccu = null;

    public DebugSerialAccumulator(String name, Object userData) {
        this.name = name;
        this.userData = userData;
    }

    @Override
    public void init(int capacity) {
        this.waitQueue = new AtomicReferenceArray(capacity);
        this.capacity = capacity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public E enterNext(E newWork) {
        long myClock = this.threadClock.get();
        return this.enterNext(myClock, newWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E enterNext(long workClock, E newWork) {
        boolean success;
        assert (this.waitQueue != null) : "Missing call to init() before use";
        assert (this.active.get().booleanValue()) : "enterNext() invoked while serial accu is inactive.\nThe probable cause is that the calling code is not a Task submitted to the ThreadPool.";
        if (newWork != null) {
            if (workClock == this.clock.get()) {
                this.checkAfterEnter(newWork);
                return newWork;
            }
            if (workClock >= this.clock.get() + (long)this.capacity) {
                this.nbWaiters.incrementAndGet();
                try {
                    Object object = this.nextClock;
                    synchronized (object) {
                        while (workClock >= this.clock.get() + (long)this.capacity) {
                            try {
                                this.nextClock.wait();
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 17, 21, 5, 6, 10] lbl22 : MonitorExitStatement: MONITOREXIT : var4_3
                                this.nbWaiters.decrementAndGet();
                                return null;
                            }
                        }
                    }
                }
                finally {
                    this.nbWaiters.decrementAndGet();
                }
            }
            int index = (int)(workClock % (long)this.capacity);
            boolean success2 = this.waitQueue.compareAndSet(index, null, new ClockedWork<E>(workClock, newWork));
            assert (success2) : "Clock skew larger than circular waitQueue size";
        }
        if (this.capacity == 0) {
            this.afterFailedEnter();
            return null;
        }
        while (true) {
            long curClock;
            int topIndex;
            ClockedWork top;
            if ((top = (ClockedWork)this.waitQueue.getAndSet(topIndex = (int)((curClock = this.clock.get()) % (long)this.capacity), null)) == null) {
                this.afterFailedEnter();
                return null;
            }
            if (top.getClock() == curClock) {
                assert (top.getClock() == this.clock.get());
                this.checkAfterEnter(newWork);
                return top.getWork();
            }
            success = this.waitQueue.compareAndSet(topIndex, null, top);
            assert (success);
        }
    }

    private void checkAfterEnter(E newWork) {
        boolean success = this.entered.compareAndSet(false, true);
        assert (success) : "enterNext() invoked twice without a matching leaveNext()";
        if (this.firstEnter.get().booleanValue()) {
            assert (newWork != null) : "First call to enterNext() must supply a non-null work argument";
        } else assert (newWork == null) : "Subsequent calls to enterNext() must supply a null work argument";
        this.firstEnter.set(false);
        if (newWork != null) {
            DebugSerialAccumulator<?> myPrevious = previousAccu.get();
            if (this.commonPreviousAccu == null) {
                if (myPrevious != null) {
                    this.commonPreviousAccu = myPrevious;
                }
            } else if (myPrevious != null) assert (myPrevious == this.commonPreviousAccu) : "The SerialAccus are not entered by all threads in the same order.\nCurrent thread entered " + myPrevious.name + " followed by " + this.name + "\nwhereas a previous thread entered " + this.commonPreviousAccu.name + " followed by " + this.name;
        }
    }

    private void afterFailedEnter() {
        this.firstEnter.set(true);
        firstAccu.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveNext() {
        previousAccu.set(this);
        assert (this.active.get().booleanValue()) : "leaveNext() invoked while serial section is inactive The probable cause is that the calling code is not a Task submitted to the ThreadPool.";
        boolean success = this.entered.compareAndSet(true, false);
        assert (success) : "leaveNext() invoked without a prior successful (returning non-null) call to enterNext()";
        this.clock.incrementAndGet();
        if (this.nbWaiters.get() > 0) {
            Object object = this.nextClock;
            synchronized (object) {
                this.nextClock.notifyAll();
            }
        }
    }

    @Override
    public long getCurrentClock() {
        assert (this.entered.get()) : "getCurrentClock() is only valid between enterNext() and leaveNext()";
        return this.clock.get();
    }

    @Override
    public long getMyClock() {
        if (!firstAccu.get().booleanValue()) {
            Debug.warn("getMyClock() invoked on an SerialAccu that is not the first one.\nThis is rarely correct, in general you should use the result of getCurrentClock() in the previous SerialAccu instead.", new Object[0]);
        }
        return this.threadClock.get();
    }

    @Override
    public void setClock(long clock) {
        this.threadClock.set(clock);
    }

    @Override
    public void setActive(boolean value) {
        boolean previous = this.active.get();
        assert (previous != value) : "setActive(" + value + ") was invoked but active status was already " + value;
        this.active.set(value);
        if (value) {
            firstAccu.set(true);
        } else {
            previousAccu.set(null);
        }
    }

    @Override
    public void clearClock() {
        this.threadClock.remove();
        previousAccu.remove();
        this.active.remove();
        this.firstEnter.remove();
        this.commonPreviousAccu = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClockedWork<E>
    implements Comparable<ClockedWork<E>> {
        private final long clock;
        private final E work;

        public ClockedWork(long clock, E work) {
            this.clock = clock;
            this.work = work;
        }

        public long getClock() {
            return this.clock;
        }

        public E getWork() {
            return this.work;
        }

        @Override
        public int compareTo(ClockedWork<E> other) {
            if (this.clock < other.clock) {
                return -1;
            }
            if (this.clock > other.clock) {
                return 1;
            }
            assert (this == other) : "Two works with the same clock " + this.clock + " were submitted";
            return 0;
        }
    }
}

