/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread.serial;

import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.utils.concurrent.SerialSection;
import ch.tachyon.tunnel.utils.concurrent.ThreadPool;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugSerialSection
extends SerialSection
implements ISerialSectionExt {
    private final ThreadLocal<Long> clock = new ThreadLocal();
    private final String name;
    private final Object userData;
    private final ThreadLocal<Boolean> active = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final ThreadLocal<Boolean> used = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private final ThreadLocal<Integer> ticks = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private final AtomicBoolean entered = new AtomicBoolean(false);
    private static final ThreadLocal<DebugSerialSection> previousSection = new ThreadLocal();
    private DebugSerialSection commonPreviousSection = null;

    public DebugSerialSection(ThreadPool threadPool, String name, Object userData) {
        super(threadPool);
        this.name = name;
        this.userData = userData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public <E> E getUserData(Class<E> expectedType) {
        if (this.userData == null) {
            return null;
        }
        if (expectedType.isInstance(this.userData)) {
            return (E)this.userData;
        }
        throw new ClassCastException("Cannopt cast " + this.userData.getClass() + " to " + expectedType);
    }

    @Override
    public void enterSerialSection() {
        assert (!this.used.get().booleanValue()) : "enterSerialSection() invoked twice by the same Thread without leaveSerialSection()";
        this.used.set(true);
        int nTicks = this.ticks.get();
        if (nTicks == 0) {
            assert (false) : "The section was used more than once during clock " + this.clock.get();
        } else if (nTicks > 1) assert (false) : "The section was missed during clock " + (this.clock.get() - (long)nTicks + 1L);
        this.ticks.set(0);
        assert (this.active.get().booleanValue()) : "enterSerialSection() invoked while serial section is inactive.\nThe probable cause is that the calling code is not a Task submitted to the ThreadPool.";
        super.enterSerialSection(this.clock.get());
        boolean success = this.entered.compareAndSet(false, true);
        assert (success) : "enterSerialSection() invoked twice without a matching leaveSerialSection()";
        DebugSerialSection myPrevious = previousSection.get();
        if (this.commonPreviousSection == null) {
            if (myPrevious != null) {
                this.commonPreviousSection = myPrevious;
            }
        } else if (myPrevious != null) assert (myPrevious == this.commonPreviousSection) : "The SerialSections are not entered by all threads in the same order.\nCurrent thread entered " + myPrevious.name + " followed by " + this.name + "\nwhereas a previous thread entered " + this.commonPreviousSection.name + " followed by " + this.name;
    }

    @Override
    public void leaveSerialSection() {
        previousSection.set(this);
        assert (this.active.get().booleanValue()) : "leaveSerialSection() invoked while serial section is inactive The probable cause is that the calling code is not a Task submitted to the ThreadPool.";
        boolean success = this.entered.compareAndSet(true, false);
        assert (success) : "leaveSerialSection() invoked without a prior call to enterSerialSection()";
        super.leaveSerialSection();
        assert (this.used.get().booleanValue()) : "leaveSerialSection() invoked twice by the same Thread during the same clock " + this.clock.get();
        this.used.set(false);
        this.clock.set(this.clock.get() + 1L);
    }

    @Override
    public void sync() {
        this.enterSerialSection();
        this.leaveSerialSection();
    }

    @Override
    public long getClock() {
        return this.clock.get();
    }

    @Override
    public void setClock(long clock) {
        this.clock.set(clock);
        this.ticks.set(this.ticks.get() + 1);
    }

    @Override
    public void setActive(boolean value) {
        boolean previous = this.active.get();
        assert (previous != value) : "setActive(" + value + ") was invoked but active status was already " + value;
        this.active.set(value);
    }

    @Override
    public void clearClock() {
        this.clock.remove();
        previousSection.remove();
        this.active.remove();
        this.used.remove();
        this.ticks.remove();
        this.commonPreviousSection = null;
    }
}

