/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread.serial;

import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialAccumulatorEx;
import ch.tachyon.tunnel.utils.Monitor;
import ch.tachyon.tunnel.utils.concurrent.ThreadPool;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfiledSerialAccumulator<E>
implements ISerialAccumulatorEx<E> {
    private final ThreadPool threadPool;
    private final String name;
    private final Object userData;
    private int capacity;
    private final Object nextClock = new Monitor("nextClock");
    private final AtomicInteger nbWaiters = new AtomicInteger();
    private AtomicReferenceArray<ClockedWork<E>> waitQueue;
    private final AtomicLong clock = new AtomicLong(0L);
    private final ThreadLocal<Long> threadClock = new ThreadLocal();
    private final AtomicLong nbImmediate = new AtomicLong();
    private final AtomicLong nbTotal = new AtomicLong();
    private final AtomicLong nbOverflows = new AtomicLong();
    private final AtomicLong parallelTime = new AtomicLong();
    private final AtomicLong serialTime = new AtomicLong();
    private final AtomicLong enterTime = new AtomicLong();
    private final AtomicLong leaveTime = new AtomicLong();
    private final AtomicLong blockedTime = new AtomicLong();
    private ThreadLocal<Long> lastTime = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return System.nanoTime();
        }
    };
    private long counter = 0L;
    public static long resyncTime;
    public static long scheduleTime;

    public ProfiledSerialAccumulator(ThreadPool threadPool, String name, Object userData) {
        this.threadPool = threadPool;
        this.name = name;
        this.userData = userData;
    }

    @Override
    public void init(int capacity) {
        this.waitQueue = new AtomicReferenceArray(capacity);
        this.capacity = capacity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public E enterNext(E newWork) {
        long myClock = this.threadClock.get();
        return this.enterNext(myClock, newWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E enterNext(long workClock, E newWork) {
        boolean success;
        long time1 = System.nanoTime();
        this.parallelTime.addAndGet(time1 - this.lastTime.get());
        ++this.counter;
        if (newWork != null) {
            this.nbTotal.incrementAndGet();
            if (workClock == this.clock.get()) {
                this.nbImmediate.incrementAndGet();
                long time2 = System.nanoTime();
                this.enterTime.addAndGet(time2 - time1);
                this.lastTime.set(time2);
                return newWork;
            }
            if (workClock >= this.clock.get() + (long)this.capacity) {
                this.nbOverflows.incrementAndGet();
                this.nbWaiters.incrementAndGet();
                try {
                    Object time2 = this.nextClock;
                    synchronized (time2) {
                        while (workClock >= this.clock.get() + (long)this.capacity) {
                            try {
                                this.nextClock.wait();
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                                // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 18, 5, 6, 10] lbl31 : MonitorExitStatement: MONITOREXIT : time2
                                this.nbWaiters.decrementAndGet();
                                return null;
                            }
                        }
                    }
                }
                finally {
                    this.nbWaiters.decrementAndGet();
                }
                long time2 = System.nanoTime();
                this.blockedTime.addAndGet(time2 - time1);
                time1 = time2;
            }
            int index = (int)(workClock % (long)this.capacity);
            boolean success2 = this.waitQueue.compareAndSet(index, null, new ClockedWork<E>(workClock, newWork));
            assert (success2) : "Clock skew larger than circular waitQueue size";
        }
        if (this.capacity == 0) {
            return null;
        }
        while (true) {
            long curClock;
            int topIndex;
            ClockedWork top;
            if ((top = (ClockedWork)this.waitQueue.getAndSet(topIndex = (int)((curClock = this.clock.get()) % (long)this.capacity), null)) == null) {
                long time2 = System.nanoTime();
                this.enterTime.addAndGet(time2 - time1);
                this.lastTime.set(time2);
                return null;
            }
            if (top.getClock() == curClock) {
                long time2 = System.nanoTime();
                this.enterTime.addAndGet(time2 - time1);
                this.lastTime.set(time2);
                return top.getWork();
            }
            success = this.waitQueue.compareAndSet(topIndex, null, top);
            assert (success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveNext() {
        long time1 = System.nanoTime();
        this.serialTime.addAndGet(time1 - this.lastTime.get());
        this.clock.incrementAndGet();
        if (this.nbWaiters.get() > 0) {
            Object object = this.nextClock;
            synchronized (object) {
                this.nextClock.notifyAll();
            }
        }
        long time2 = System.nanoTime();
        this.leaveTime.addAndGet(time2 - time1);
        this.lastTime.set(time2);
    }

    @Override
    public long getCurrentClock() {
        return this.clock.get();
    }

    @Override
    public long getMyClock() {
        return this.threadClock.get();
    }

    @Override
    public void setClock(long clock) {
        this.threadClock.set(clock);
    }

    @Override
    public void setActive(boolean value) {
        long time = System.nanoTime();
        if (!value) {
            this.parallelTime.addAndGet(time - this.lastTime.get());
        }
        this.lastTime.set(time);
    }

    @Override
    public synchronized void clearClock() {
        this.threadClock.remove();
        if (this.counter > 0L) {
            int nbThreads = Math.min(Runtime.getRuntime().availableProcessors(), this.threadPool.getPoolSize());
            this.parallelTime.set(this.parallelTime.get() / (long)nbThreads);
            this.enterTime.set(this.enterTime.get() / (long)nbThreads);
            this.leaveTime.set(this.leaveTime.get() / (long)nbThreads);
            this.blockedTime.set(this.blockedTime.get() / (long)nbThreads);
            this.serialTime.set(this.serialTime.get() / (long)nbThreads);
            System.out.println("SerialAccumulator \"" + this.name + "\" (capacity: " + this.capacity + ") statistics:");
            DecimalFormat formatter = new DecimalFormat("#,##0");
            DecimalFormat ratioFtr = new DecimalFormat("#,##0.00");
            long totalTime = this.parallelTime.get() + this.blockedTime.get() + this.serialTime.get() + this.enterTime.get() + this.leaveTime.get();
            long runningTime = this.parallelTime.get() + this.serialTime.get() + this.enterTime.get() + this.leaveTime.get();
            System.out.println(MessageFormat.format(" Active time:    {0}ns", formatter.format(totalTime / this.counter)));
            System.out.println(MessageFormat.format("   Blocked time: {0}ns ({1}%)", formatter.format(this.blockedTime.get() / this.counter), ratioFtr.format((double)this.blockedTime.get() * 100.0 / (double)totalTime)));
            System.out.println(MessageFormat.format("   Outside time: {0}ns ({1}%)", formatter.format((this.parallelTime.get() + this.enterTime.get()) / this.counter), ratioFtr.format((double)(this.parallelTime.get() + this.enterTime.get()) * 100.0 / (double)totalTime)));
            System.out.println(MessageFormat.format("     Enter time: {0}ns ({1}%)", formatter.format(this.enterTime.get() / this.counter), ratioFtr.format((double)this.enterTime.get() * 100.0 / (double)(this.parallelTime.get() + this.enterTime.get()))));
            System.out.println(MessageFormat.format("   Inside time:  {0}ns ({1}%)", formatter.format((this.serialTime.get() + this.leaveTime.get()) / this.counter), ratioFtr.format((double)(this.serialTime.get() + this.leaveTime.get()) * 100.0 / (double)totalTime)));
            System.out.println(MessageFormat.format("     Leave time: {0}ns ({1}%)", formatter.format(this.leaveTime.get() / this.counter), ratioFtr.format((double)this.leaveTime.get() * 100.0 / (double)(this.serialTime.get() + this.leaveTime.get()))));
            System.out.println(MessageFormat.format(" Optimal ratio: {0}", ratioFtr.format((double)runningTime / (double)(this.serialTime.get() + this.enterTime.get() + this.leaveTime.get()))));
            System.out.println(MessageFormat.format(" Actual ratio:  {0}", ratioFtr.format((double)runningTime * (double)nbThreads / (double)totalTime)));
            long nbDelegates = this.nbTotal.get() - this.nbImmediate.get();
            System.out.println(MessageFormat.format("  -Delegates:  {0} / {1} ({2}%)", nbDelegates, this.nbTotal.get(), (double)nbDelegates * 100.0 / (double)this.nbTotal.get()));
            System.out.println(MessageFormat.format("  -Overflows:  {0} / {1} ({2}%)", this.nbOverflows.get(), this.nbTotal.get(), (double)this.nbOverflows.get() * 100.0 / (double)this.nbTotal.get()));
            scheduleTime += (this.enterTime.get() + this.leaveTime.get()) * (long)nbThreads;
            resyncTime += this.blockedTime.get() * (long)nbThreads;
            this.counter = 0L;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClockedWork<E>
    implements Comparable<ClockedWork<E>> {
        private final long clock;
        private final E work;

        public ClockedWork(long clock, E work) {
            this.clock = clock;
            this.work = work;
        }

        public long getClock() {
            return this.clock;
        }

        public E getWork() {
            return this.work;
        }

        @Override
        public int compareTo(ClockedWork<E> other) {
            if (this.clock < other.clock) {
                return -1;
            }
            if (this.clock > other.clock) {
                return 1;
            }
            assert (this == other) : "Two works with the same clock " + this.clock + " were submitted";
            return 0;
        }
    }
}

