/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread.serial;

import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialAccumulatorEx;
import ch.tachyon.tunnel.utils.Monitor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialAccumulatorImpl<E>
implements ISerialAccumulatorEx<E> {
    private final String name;
    private final Object userData;
    private int capacity;
    private final Object nextClock = new Monitor("nextClock");
    private final AtomicInteger nbWaiters = new AtomicInteger();
    private AtomicReferenceArray<ClockedWork<E>> waitQueue;
    private final AtomicLong clock = new AtomicLong(0L);
    private final ThreadLocal<Long> threadClock = new ThreadLocal();

    public SerialAccumulatorImpl(String name, Object userData) {
        this.name = name;
        this.userData = userData;
    }

    @Override
    public void init(int capacity) {
        this.waitQueue = new AtomicReferenceArray(capacity);
        this.capacity = capacity;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public E enterNext(E newWork) {
        long myClock = this.threadClock.get();
        return this.enterNext(myClock, newWork);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public E enterNext(long workClock, E newWork) {
        boolean success;
        if (newWork != null) {
            if (workClock == this.clock.get()) {
                return newWork;
            }
            if (workClock >= this.clock.get() + (long)this.capacity) {
                this.nbWaiters.incrementAndGet();
                try {
                    Object object = this.nextClock;
                    synchronized (object) {
                        while (workClock >= this.clock.get() + (long)this.capacity) {
                            try {
                                this.nextClock.wait();
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 17, 19, 5, 6, 10] lbl17 : MonitorExitStatement: MONITOREXIT : var4_3
                                this.nbWaiters.decrementAndGet();
                                return null;
                            }
                        }
                    }
                }
                finally {
                    this.nbWaiters.decrementAndGet();
                }
            }
            int index = (int)(workClock % (long)this.capacity);
            boolean success2 = this.waitQueue.compareAndSet(index, null, new ClockedWork<E>(workClock, newWork));
            assert (success2) : "Clock skew larger than circular waitQueue size";
        }
        if (this.capacity == 0) {
            return null;
        }
        while (true) {
            long curClock;
            int topIndex;
            ClockedWork top;
            if ((top = (ClockedWork)this.waitQueue.getAndSet(topIndex = (int)((curClock = this.clock.get()) % (long)this.capacity), null)) == null) {
                return null;
            }
            if (top.getClock() == curClock) {
                assert (top.getClock() == this.clock.get());
                return top.getWork();
            }
            success = this.waitQueue.compareAndSet(topIndex, null, top);
            assert (success);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void leaveNext() {
        this.clock.incrementAndGet();
        if (this.nbWaiters.get() > 0) {
            Object object = this.nextClock;
            synchronized (object) {
                this.nextClock.notifyAll();
            }
        }
    }

    @Override
    public long getCurrentClock() {
        return this.clock.get();
    }

    @Override
    public long getMyClock() {
        return this.threadClock.get();
    }

    @Override
    public void setClock(long clock) {
        this.threadClock.set(clock);
    }

    @Override
    public void setActive(boolean value) {
    }

    @Override
    public void clearClock() {
        this.threadClock.remove();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClockedWork<E>
    implements Comparable<ClockedWork<E>> {
        private final long clock;
        private final E work;

        public ClockedWork(long clock, E work) {
            this.clock = clock;
            this.work = work;
        }

        public long getClock() {
            return this.clock;
        }

        public E getWork() {
            return this.work;
        }

        @Override
        public int compareTo(ClockedWork<E> other) {
            if (this.clock < other.clock) {
                return -1;
            }
            if (this.clock > other.clock) {
                return 1;
            }
            assert (this == other) : "Two works with the same clock " + this.clock + " were submitted";
            return 0;
        }
    }
}

