/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread.serial;

import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.utils.concurrent.SerialSection;
import ch.tachyon.tunnel.utils.concurrent.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialSectionImpl
extends SerialSection
implements ISerialSectionExt {
    private final ThreadLocal<Long> clock = new ThreadLocal();
    private final String name;
    private final Object userData;

    public SerialSectionImpl(ThreadPool threadPool, String name, Object userData) {
        super(threadPool);
        this.name = name;
        this.userData = userData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public <E> E getUserData(Class<E> expectedType) {
        if (this.userData == null) {
            return null;
        }
        if (expectedType.isInstance(this.userData)) {
            return (E)this.userData;
        }
        throw new ClassCastException("Cannopt cast " + this.userData.getClass() + " to " + expectedType);
    }

    @Override
    public void enterSerialSection() {
        super.enterSerialSection(this.clock.get());
    }

    @Override
    public void leaveSerialSection() {
        super.leaveSerialSection();
        this.clock.set(this.clock.get() + 1L);
    }

    @Override
    public void sync() {
        super.sync(this.clock.get());
        this.clock.set(this.clock.get() + 1L);
    }

    @Override
    public long getClock() {
        return this.clock.get();
    }

    @Override
    public void setClock(long clock) {
        this.clock.set(clock);
    }

    @Override
    public void setActive(boolean value) {
    }

    @Override
    public void clearClock() {
        this.clock.remove();
    }
}

