/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.gui;

import ch.tachyon.tunnel.engine.ProcessingInfoBridge;
import ch.tachyon.tunnel.engine.gui.ParameterGuiBuilder;
import ch.tachyon.tunnel.host.IParameter;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.utils.Utils;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DoubleControl
extends JPanel {
    private final IParameter parameter;
    private final IProcessingInfo info;
    private final ScaleType scaleType;
    private final double minValue;
    private final double maxValue;
    private final int nbSteps;
    private JSlider slider;
    private JSpinner spinner;
    private double curValue;
    private boolean isAdjusting = false;

    public DoubleControl(IParameter parameter, IProcessingInfo info) {
        String tooltip;
        this.parameter = parameter;
        this.info = info;
        this.scaleType = parameter.getScaleType();
        Range range = parameter.getRange();
        this.minValue = range == null ? Double.NEGATIVE_INFINITY : range.minValue();
        this.maxValue = range == null ? Double.POSITIVE_INFINITY : range.maxValue();
        this.curValue = this.readValue();
        Scale scale = parameter.getAnnotation(Scale.class);
        this.nbSteps = scale != null ? scale.steps() : 10;
        this.setLayout(new BoxLayout(this, 2));
        if (!Double.isInfinite(this.minValue) && !Double.isInfinite(this.maxValue)) {
            this.slider = new JSlider(0, this.toSlider(this.minValue), this.toSlider(this.maxValue), this.toSlider(this.curValue));
            this.add(this.slider);
            if (parameter.getDescription() != null) {
                tooltip = ParameterGuiBuilder.formatMultiLineAsHtml(parameter.getDescription());
                this.slider.setToolTipText(tooltip);
            }
            this.slider.setMinimum(this.toSlider(this.minValue));
            this.slider.setMaximum(this.toSlider(this.maxValue));
            this.slider.setValue(this.toSlider(this.curValue));
            this.slider.setPaintLabels(false);
            if (UIManager.getLookAndFeel().getName().contains("GTK")) {
                try {
                    this.slider.setFont(this.getFont().deriveFont(0.0f));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (DoubleControl.this.isAdjusting) {
                        return;
                    }
                    DoubleControl.this.isAdjusting = true;
                    DoubleControl.this.sliderUpdated();
                    DoubleControl.this.isAdjusting = false;
                }
            });
            this.slider.setFocusable(false);
        }
        this.spinner = new JSpinner();
        this.add(this.spinner);
        if (parameter.getDescription() != null) {
            tooltip = ParameterGuiBuilder.formatMultiLineAsHtml(parameter.getDescription());
            this.spinner.setToolTipText(tooltip);
        }
        final double maxValueT = this.transformValue(this.maxValue);
        final double minValueT = this.transformValue(this.minValue);
        double curValueT = this.transformValue(this.curValue);
        double ticks = (this.maxValue - this.minValue) / (double)this.nbSteps;
        SpinnerNumberModel model = new SpinnerNumberModel(curValueT, minValueT, maxValueT, ticks){
            private static final long serialVersionUID = 3232386477406960692L;

            public Object getNextValue() {
                double curValueT = (Double)super.getValue();
                double curValue = DoubleControl.this.untransformValue(curValueT);
                double result = DoubleControl.this.backScale(DoubleControl.this.forwScale(curValue) + super.getStepSize().doubleValue());
                double resultT = DoubleControl.this.transformValue(result);
                if (resultT < minValueT) {
                    resultT = minValueT;
                } else if (resultT > maxValueT) {
                    resultT = maxValueT;
                }
                return resultT;
            }

            public Object getPreviousValue() {
                double curValueT = (Double)super.getValue();
                double curValue = DoubleControl.this.untransformValue(curValueT);
                double result = DoubleControl.this.backScale(DoubleControl.this.forwScale(curValue) - super.getStepSize().doubleValue());
                double resultT = DoubleControl.this.transformValue(result);
                if (resultT < minValueT) {
                    resultT = minValueT;
                } else if (resultT > maxValueT) {
                    resultT = maxValueT;
                }
                return resultT;
            }
        };
        if (!Utils.isGcj()) {
            if (!Double.isInfinite(this.minValue) && !Double.isInfinite(this.maxValue)) {
                this.spinner.setModel(model);
            } else {
                this.spinner.setModel(new SpinnerNumberModel(this.curValue, this.minValue, this.maxValue, 1.0));
            }
        } else {
            this.spinner.setValue(curValueT);
        }
        final JFormattedTextField textField = ((JSpinner.NumberEditor)this.spinner.getEditor()).getTextField();
        int columns = textField.getColumns();
        if (columns < 5) {
            textField.setColumns(5);
        } else if (columns > 20) {
            textField.setColumns(20);
        }
        textField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        textField.selectAll();
                    }
                });
            }
        });
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (DoubleControl.this.isAdjusting) {
                    return;
                }
                DoubleControl.this.isAdjusting = true;
                DoubleControl.this.spinnerUpdated();
                DoubleControl.this.isAdjusting = false;
            }
        });
    }

    private double readValue() {
        Object data = this.parameter.getInternalValue();
        if (data instanceof Number) {
            return ((Number)data).doubleValue();
        }
        return 0.0;
    }

    private void writeValue(double value) {
        if (this.parameter.getType().equals(Double.class) || this.parameter.getType().equals(Double.TYPE)) {
            this.parameter.setInternalValue(value);
        } else {
            this.parameter.setInternalValue(Float.valueOf((float)value));
        }
    }

    private double transformValue(double value) {
        return this.parameter.getTransform().transform(value, new ProcessingInfoBridge(this.info));
    }

    private double untransformValue(double value) {
        return this.parameter.getTransform().untransform(value, new ProcessingInfoBridge(this.info));
    }

    private boolean fireValue(double value) {
        value = Math.max(value, this.minValue);
        if (this.curValue != (value = Math.min(value, this.maxValue))) {
            this.curValue = value;
            this.writeValue(value);
            return true;
        }
        return false;
    }

    private void sliderUpdated() {
        if (this.fireValue(this.fromSlider(this.slider.getValue()))) {
            this.updateSpinner();
        }
    }

    private void spinnerUpdated() {
        if (this.fireValue(this.untransformValue(((Number)this.spinner.getValue()).doubleValue()))) {
            this.updateSlider();
        }
    }

    private void updateSlider() {
        if (this.slider != null) {
            this.slider.setValue(this.toSlider(this.curValue));
        }
    }

    private void updateSpinner() {
        this.spinner.setValue(this.transformValue(this.curValue));
    }

    private double forwScale(double value) {
        double result = this.scaleType.forwScale(value, this.minValue, this.maxValue);
        if (result < this.minValue) {
            result = this.minValue;
        } else if (result > this.maxValue) {
            result = this.maxValue;
        }
        return result;
    }

    private double backScale(double value) {
        double result = this.scaleType.backScale(value, this.minValue, this.maxValue);
        if (result < this.minValue) {
            result = this.minValue;
        } else if (result > this.maxValue) {
            result = this.maxValue;
        }
        return result;
    }

    private int toSlider(double value) {
        value = this.forwScale(value);
        return (int)(1000.0 * (value - this.minValue) / (this.maxValue - this.minValue) + 0.5);
    }

    private double fromSlider(int value) {
        double res = (double)value * (this.maxValue - this.minValue) / 1000.0 + this.minValue;
        return this.backScale(res);
    }
}

