/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.storage;

import ch.tachyon.tunnel.engine.bean.ClassInfo;
import ch.tachyon.tunnel.engine.bean.MemberInfo;
import ch.tachyon.tunnel.engine.storage.RunningCache;
import ch.tachyon.tunnel.engine.storage.XmlCommon;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlWriter
extends XmlCommon {
    public Document toXml(Object obj, String name) throws InvocationTargetException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Class<?> type;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(name);
            Class<?> clazz = type = obj == null ? null : obj.getClass();
            if (type != null) {
                root.setAttribute("type", type.getName());
            } else {
                root.setAttribute("isNull", "true");
            }
            document.appendChild(root);
            RunningCache cache = new RunningCache();
            this.toXml(document, root, type, obj, cache);
            for (Object item : cache.getReferencedObjects()) {
                Element node = cache.getNode(item);
                long key = cache.getKey(item);
                node.setAttribute("key", Long.toString(key));
            }
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    private void toXml(Document document, Element elt, Class<?> type, Object value, RunningCache cache) throws InvocationTargetException {
        if (value == null) {
            elt.setAttribute("isNull", "true");
            return;
        }
        if (XmlCommon.isSimple(type)) {
            Text text = document.createTextNode(value.toString());
            elt.appendChild(text);
            return;
        }
        if (cache.isDone(value)) {
            long key = cache.getKey(value);
            elt.setAttribute("ref", Long.toString(key));
            return;
        }
        cache.add(value, elt);
        if (Map.class.isAssignableFrom(type)) {
            this.mapToXml(document, elt, value, cache);
        } else if (Collection.class.isAssignableFrom(type)) {
            this.collectionToXml(document, elt, value, cache);
        } else if (type.isArray()) {
            this.arrayToXml(document, elt, (Object[])value, cache);
        } else if (Enum.class.isAssignableFrom(type)) {
            Enum enumVal = (Enum)value;
            this.toXml(document, elt, String.class, enumVal.name(), cache);
        } else {
            ClassInfo info = new ClassInfo(type);
            for (MemberInfo childMember : info.getMembers()) {
                Element child = document.createElement(childMember.getName());
                elt.appendChild(child);
                Class<?> childType = childMember.getType();
                Object childValue = childMember.getValue(value);
                this.toXml(document, child, childType, childValue, cache);
            }
        }
    }

    private void mapToXml(Document document, Element elt, Object value, RunningCache cache) throws InvocationTargetException {
        Class<?> itemsType;
        Map map = (Map)value;
        Class<?> keysType = XmlWriter.getCommonClass(map.keySet());
        if (keysType != null) {
            elt.setAttribute("keyType", keysType.getName());
        }
        if ((itemsType = XmlWriter.getCommonClass(map.values())) != null) {
            elt.setAttribute("itemType", itemsType.getName());
        }
        for (Map.Entry entry : map.entrySet()) {
            Class<?> itemType;
            Class<?> keyType;
            Element keyChild = document.createElement("key");
            elt.appendChild(keyChild);
            Object key = entry.getKey();
            Class<?> clazz = keyType = key == null ? null : key.getClass();
            if (keysType == null && keyType != null) {
                keyChild.setAttribute("type", keyType.getName());
            }
            this.toXml(document, keyChild, keyType, key, cache);
            Element itemChild = document.createElement("item");
            elt.appendChild(itemChild);
            Object item = entry.getValue();
            Class<?> clazz2 = itemType = item == null ? null : item.getClass();
            if (itemsType == null && itemType != null) {
                itemChild.setAttribute("type", itemType.getName());
            }
            this.toXml(document, itemChild, itemType, item, cache);
        }
    }

    private void collectionToXml(Document document, Element elt, Object value, RunningCache cache) throws InvocationTargetException {
        Collection coll = (Collection)value;
        Class<?> itemsType = XmlWriter.getCommonClass(coll);
        if (itemsType != null) {
            elt.setAttribute("itemType", itemsType.getName());
        }
        for (Object item : coll) {
            Class<?> itemType;
            Element child = document.createElement("item");
            elt.appendChild(child);
            Class<?> clazz = itemType = item == null ? null : item.getClass();
            if (itemsType == null && itemType != null) {
                child.setAttribute("type", itemType.getName());
            }
            this.toXml(document, child, itemType, item, cache);
        }
    }

    private void arrayToXml(Document document, Element elt, Object[] array, RunningCache cache) throws InvocationTargetException {
        Class<?> itemsType = XmlWriter.getCommonClass(Arrays.asList(array));
        if (itemsType != null) {
            elt.setAttribute("itemType", itemsType.getName());
        }
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> itemType;
            Object item = objectArray[n2];
            Element child = document.createElement("item");
            elt.appendChild(child);
            Class<?> clazz = itemType = item == null ? null : item.getClass();
            if (itemsType == null && itemType != null) {
                child.setAttribute("type", itemType.getName());
            }
            this.toXml(document, child, itemType, item, cache);
            ++n2;
        }
    }

    private static Class<?> getCommonClass(Collection<?> coll) {
        Class<?> result = null;
        for (Object item : coll) {
            if (item == null) continue;
            Class<?> type = item.getClass();
            if (result == null) {
                result = type;
                continue;
            }
            if (result.equals(type)) continue;
            return null;
        }
        return result;
    }

    public void saveXml(Object obj, String name, Writer writer) throws IOException, InvocationTargetException {
        Document doc = this.toXml(obj, name);
        DOMSource src = new DOMSource(doc);
        StreamResult dst = new StreamResult(writer);
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", 2);
            Transformer trans = factory.newTransformer();
            trans.setOutputProperty("indent", "yes");
            trans.transform(src, dst);
        }
        catch (TransformerException ex) {
            throw new UnsupportedOperationException(ex);
        }
        writer.flush();
    }

    public void saveXml(Object obj, String name, File file) throws IOException, InvocationTargetException {
        FileWriter fwriter = new FileWriter(file, false);
        BufferedWriter bwriter = new BufferedWriter(fwriter);
        try {
            this.saveXml(obj, name, bwriter);
        }
        finally {
            bwriter.close();
        }
    }
}

