/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleConverter {
    public static Object fromDouble(double value, Class<?> type) {
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return value;
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf((float)value);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return (long)value;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return (int)value;
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return (short)value;
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return (byte)value;
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            if (value > 0.0) {
                return true;
            }
            return false;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return type.getEnumConstants()[(int)value];
        }
        throw new IllegalArgumentException("Cannot convert double to " + type);
    }

    public static double toDouble(Object value, Class<?> type) {
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return (Double)value;
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return ((Float)value).floatValue();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return ((Long)value).longValue();
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return ((Integer)value).intValue();
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return ((Short)value).shortValue();
        }
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return ((Byte)value).byteValue();
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.TRUE.equals(value) ? 1.0 : 0.0;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return ((Enum)value).ordinal();
        }
        throw new IllegalArgumentException("Cannot convert double to " + type);
    }
}

