/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

import ch.tachyon.tunnel.engine.bean.ClassInfo;
import ch.tachyon.tunnel.engine.bean.MemberInfo;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.ILoadUnload;
import ch.tachyon.tunnel.plugin.opt.thread.IDuplicatable;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginDuplicator {
    public static <E extends IPlugin> E prepareCopy(E plugin, IProcessingInfo info) {
        IPlugin copy;
        if (plugin instanceof IDuplicatable) {
            IPlugin result = (IPlugin)((IDuplicatable)((Object)plugin)).duplicate(info);
            return (E)result;
        }
        if (plugin instanceof Cloneable) {
            try {
                Method cloneMethod = plugin.getClass().getMethod("clone", new Class[0]);
                IPlugin result = (IPlugin)cloneMethod.invoke(plugin, new Object[0]);
                return (E)result;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Plugin " + plugin + " is Cloneable but the clone() method could not be invoked successfully", ex);
            }
        }
        try {
            IPlugin toto;
            copy = toto = (IPlugin)plugin.getClass().newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException("Could not instanciate a plugin " + plugin + " with the public no-arg constructor", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Could not instanciate a plugin " + plugin + " with the public no-arg constructor", ex);
        }
        if (copy instanceof ILoadUnload) {
            ((ILoadUnload)((Object)copy)).load(info);
        }
        try {
            for (MemberInfo property : new ClassInfo(plugin.getClass()).getMembers()) {
                Object value = property.getReader().invoke(plugin, new Object[0]);
                property.getWriter().invoke((Object)copy, value);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot copy plugin's parameter to another instance", ex);
        }
        return (E)copy;
    }
}

