/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.host;

import ch.tachyon.tunnel.engine.PluginsImpl;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.utils.ParentLastUrlClassLoader;
import ch.tachyon.tunnel.host.IEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginBundle {
    private final URL url;
    private final boolean external;
    private final MtContext mtContext = new MtContext();
    private ClassLoader classLoader;
    private static Map<String, WeakReference<ClassLoader>> classLoaderCache = new HashMap<String, WeakReference<ClassLoader>>();

    public PluginBundle(File jarFile, boolean external) {
        this(PluginBundle.file2url(jarFile), external);
    }

    private static URL file2url(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public PluginBundle(URL jarFileUrl, boolean external) {
        this.url = jarFileUrl;
        this.external = external;
    }

    private ClassLoader classLoader() {
        if (this.classLoader == null) {
            WeakReference<ClassLoader> classLoaderRef = classLoaderCache.get(this.url.toExternalForm());
            if (classLoaderRef != null) {
                this.classLoader = (ClassLoader)classLoaderRef.get();
            }
            if (this.classLoader == null) {
                Debug.info("[New ClassLoader created]", new Object[0]);
                this.classLoader = new ParentLastUrlClassLoader(new URL[]{this.url}, this.external);
                classLoaderRef = new WeakReference<ClassLoader>(this.classLoader);
                classLoaderCache.put(this.url.toExternalForm(), classLoaderRef);
            }
        }
        return this.classLoader;
    }

    public ClassLoader getClassLoader(boolean create) {
        if (create) {
            return this.classLoader();
        }
        return this.classLoader;
    }

    public IMtContext getMtContext() {
        return this.mtContext;
    }

    public String getUrlString() {
        return this.url.toExternalForm();
    }

    public List<IEffect> loadAllPlugins(Class<?> ... types) throws IOException {
        return PluginsImpl.loadAllPlugins(this.classLoader(), this.mtContext, types);
    }

    public <E extends IEffect> E loadPlugin(Class<E> type, String className) {
        return PluginsImpl.loadPlugin(this.classLoader(), this.mtContext, type, className);
    }

    public void releaseLoader() {
        this.classLoader = null;
    }

    public String toString() {
        return "PluginBundle [url=" + this.url + "]";
    }
}

