/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.test;

import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.ProcessingInfo;
import ch.tachyon.tunnel.host.IEffect;
import ch.tachyon.tunnel.host.ISingleChanPushEffect;
import ch.tachyon.tunnel.host.PluginBundle;
import ch.tachyon.tunnel.utils.ThreadUtils;
import ch.tachyon.tunnel.utils.Utils;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginBundleTester {
    private final Random rnd = new Random();

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void testBundle(URL bundleUrl) throws Exception {
        try {
            if (!PluginBundleTester.$assertionsDisabled) {
                throw new AssertionError();
            }
            throw new IllegalStateException("\nAssertions are not enabled. Please enable them by specifying the -ea argument to the JVM.\nMost tests are based on assertions and hence if assertions are disabled, problems will not be detected correctly.");
        }
        catch (AssertionError var2_2) {
            threadIds = this.getThreads();
            effectNames = this.getAllPlugins(bundleUrl);
            this.checkForNewThreads(threadIds);
            classRefs = new ArrayList<WeakReference<Class<?>>>();
            threadIds = this.getThreads();
            bundle = new PluginBundle(bundleUrl, true);
            ** for (effectName : effectNames)
        }
lbl-1000:
        // 1 sources

        {
            bundle.getMtContext().setNbThreads(1);
            plugin = bundle.loadPlugin(ISingleChanPushEffect.class, effectName);
            pluginClass = Class.forName(plugin.getClassName(), true, bundle.getClassLoader(false));
            classRefs.add(new WeakReference<Class<?>>(pluginClass));
            System.out.println("[Process, size=2048] " + effectName);
            this.runEffect(plugin, 2048, 2048, true, 10);
            System.out.println("[Process, size=10] " + effectName);
            this.runEffect(plugin, 10, 10, true, 1000);
            System.out.println("[Process, size=10000] " + effectName);
            this.runEffect(plugin, 10000, 10000, true, 3);
            System.out.println("[Process, size=varying] " + effectName);
            this.runEffect(plugin, 10, 5000, true, 10);
            System.out.println("[Process & abort] " + effectName);
            this.runEffect(plugin, 2048, 2048, false, 10);
            bundle.getMtContext().setNbThreads(Math.max(2, Runtime.getRuntime().availableProcessors()));
            plugin = bundle.loadPlugin(ISingleChanPushEffect.class, effectName);
            pluginClass = Class.forName(plugin.getClassName(), true, bundle.getClassLoader(false));
            classRefs.add(new WeakReference<Class<?>>(pluginClass));
            System.out.println("[MT Process, size=2048] " + effectName);
            this.runEffect(plugin, 2048, 2048, true, 10);
            System.out.println("[MT Process, size=10] " + effectName);
            this.runEffect(plugin, 10, 10, true, 1000);
            System.out.println("[MT Process, size=10000] " + effectName);
            this.runEffect(plugin, 10000, 10000, true, 3);
            System.out.println("[MT Process, size=varying] " + effectName);
            this.runEffect(plugin, 10, 5000, true, 10);
            System.out.println("[MT Process & abort] " + effectName);
            this.runEffect(plugin, 2048, 2048, false, 10);
            continue;
        }
lbl44:
        // 1 sources

        bundle.releaseLoader();
        bundle = null;
        this.checkForNewThreads(threadIds);
        System.out.println("[Memory leak test]");
        for (WeakReference classRef : classRefs) {
            displayed = new HashSet<Class>();
            count = 0;
            while (classRef.get() != null) {
                if (count % 3 == 0) {
                    ThreadUtils.sleep(500);
                }
                if (count < 30) {
                    System.gc();
                } else if (count < 60) {
                    Utils.forceGC();
                } else {
                    Utils.fillHeap();
                }
                if (count % 3 == 0) {
                    ThreadUtils.sleep(1000);
                }
                if (++count < 90) continue;
                classList = new StringBuilder();
                for (WeakReference classRef0 : classRefs) {
                    clazz = (Class)classRef0.get();
                    if (clazz == null || displayed.contains(clazz)) continue;
                    classList.append("\n - ");
                    classList.append(clazz);
                    displayed.add(clazz);
                }
                message = "After repeated aggressive attempts to free the plugin's bundle from memory, the following plugin classes are still loaded:" + classList.toString() + "\n" + "Either you are running on a JVM that does not support class GC, or at least one plugin of the bundle has a memory leak.\n" + "Potential (and typical) memory leak causes are:\n" + " - Usage of a ThreadLocal, and failure to call remove() from all using threads\n" + " - Creation of a Thread and failure to stop it\n" + " - Illegal access to host classes or to the tachyon tunnel host or engine classes\n" + " - Reference added to a sticky system class and never removed (service provider, etc)\n" + " - JNI Global (native code) reference (a debugger breakpoint could be the cause)\n" + "   (more generally, any interaction with a debugger might eventually prevent proper garbage collection)\n" + " - JVM that does not support class garbage collection, or that has the corresponding option disabled\n" + "To help you, you may run the test again with the -DwaitOnLeak JVM option.\n" + "When this option is specified, this code will sleep for ever on a memory leak, allowing you to start a profiler and figure out the problem.";
                System.out.println(message);
                System.out.flush();
                if (System.getProperty("waitOnLeak") != null) {
                    System.out.println("\nwaitOnLeak option was specified. I'm now entering in an endless sleep loop to allow diagnosis of the memory leak.");
                    displayed.clear();
                    displayed = null;
                    classRefs.clear();
                    classRefs = null;
                    classList = null;
                    message = null;
                    threadIds.clear();
                    threadIds = null;
                    effectNames.clear();
                    effectNames = null;
                    while (true) {
                        ThreadUtils.sleep(1000);
                    }
                }
                System.out.println("*** Memory leak detected ***");
                if (!PluginBundleTester.$assertionsDisabled) {
                    throw new AssertionError((Object)"Memory leak detected. See System.out for more details");
                }
            }
        }
        System.out.println("[OK]");
    }

    private List<String> getAllPlugins(URL bundleUrl) throws IOException {
        ArrayList<String> effectNames = new ArrayList<String>();
        PluginBundle bundle = new PluginBundle(bundleUrl, true);
        for (IEffect effect : bundle.loadAllPlugins(ISingleChanPushEffect.class)) {
            effectNames.add(effect.getClassName());
        }
        bundle.releaseLoader();
        bundle = null;
        return effectNames;
    }

    private Set<Long> getThreads() {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        long[] ids = threadMxBean.getAllThreadIds();
        HashSet<Long> threadIds = new HashSet<Long>();
        long[] lArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            threadIds.add(id);
            ++n2;
        }
        return threadIds;
    }

    private void checkForNewThreads(Set<Long> threadIds) {
        ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
        long[] newThreadIds = threadMxBean.getAllThreadIds();
        StringBuilder message = new StringBuilder();
        long[] lArray = newThreadIds;
        int n = newThreadIds.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo thread;
            long id = lArray[n2];
            if (!threadIds.contains(id) && (thread = threadMxBean.getThreadInfo(id)) != null && thread.getThreadName() != null && !thread.getThreadName().equals("Finalizer thread")) {
                message.append("\nA plugin created a thread named " + thread.getThreadName() + " but failed to stop it.");
            }
            ++n2;
        }
        assert (message.length() == 0) : message.toString();
    }

    private void runEffect(ISingleChanPushEffect plugin, int minSize, int maxSize, boolean cleanup, int count) {
        ProcessingInfo info = new ProcessingInfo(1, 44100.0f, 16, -1L, maxSize, minSize == maxSize ? maxSize : -1);
        plugin.load(info);
        plugin.startProcessing(info);
        int k = 0;
        while (k < count) {
            int size = minSize == maxSize ? maxSize : minSize + this.rnd.nextInt(maxSize - minSize + 1);
            plugin.process(new float[size], size, new ISingleChanAudioSink(){

                public void writeSamples(float[] samples) {
                }
            });
            ++k;
        }
        if (cleanup) {
            plugin.process(new float[minSize], minSize / 2, new ISingleChanAudioSink(){

                public void writeSamples(float[] samples) {
                }
            });
        }
        plugin.stopProcessing();
        plugin.unload();
    }
}

