/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils.concurrent;

import ch.tachyon.tunnel.utils.concurrent.ThreadPool;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

public class SerialSection {
    private AtomicLong clock = new AtomicLong(0L);
    private final AtomicReference<Thread>[] waiters;
    private final int queueSize;
    private final long mask;

    public SerialSection(ThreadPool threadPool) {
        int poolSize = threadPool.getPoolSize();
        int qs = 1;
        while (qs < poolSize) {
            qs *= 2;
        }
        this.queueSize = qs;
        this.mask = qs - 1;
        this.waiters = new AtomicReference[this.queueSize];
        int i = 0;
        while (i < this.waiters.length) {
            this.waiters[i] = new AtomicReference<Object>(null);
            ++i;
        }
    }

    public void enterSerialSection(long threadClock) {
        if (threadClock == this.clock.get()) {
            return;
        }
        int index = (int)(threadClock & this.mask);
        this.waiters[index].set(Thread.currentThread());
        while (threadClock != this.clock.get()) {
            LockSupport.park();
        }
        this.waiters[index].set(null);
    }

    public void leaveSerialSection() {
        long nextClock = this.clock.incrementAndGet();
        int index = (int)(nextClock & this.mask);
        Thread next = this.waiters[index].get();
        if (next != null) {
            LockSupport.unpark(next);
        }
    }

    public void sync(long threadClock) {
        this.enterSerialSection(threadClock);
        this.leaveSerialSection();
    }
}

