/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils.concurrent;

import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Monitor;
import ch.tachyon.tunnel.utils.concurrent.ConcurrentLinkedBlockingQueue;
import ch.tachyon.tunnel.utils.concurrent.Task;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPool {
    private int poolSize;
    private int queueSize;
    private ConcurrentLinkedBlockingQueue<Task> taskQueue;
    private Thread[] poolThreads;
    private volatile boolean active = true;
    private List<Factory> taskFactories;
    private ThreadLocal<Factory> curFactory = new ThreadLocal();
    private final Object eachThreadLock = new Monitor("eachThreadLock");

    public ThreadPool() {
        this(-1);
    }

    public ThreadPool(int nbThreads) {
        if (nbThreads <= 0) {
            nbThreads = Runtime.getRuntime().availableProcessors();
        }
        this.poolSize = nbThreads > 1 ? nbThreads : 0;
        this.queueSize = nbThreads + 10;
        this.taskQueue = new ConcurrentLinkedBlockingQueue(this.queueSize, false);
        this.poolThreads = new Thread[this.poolSize];
        int i = 0;
        while (i < this.poolThreads.length) {
            PoolThread t = new PoolThread();
            this.poolThreads[i] = t;
            t.setName("PoolThread-" + i);
            t.start();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTaskFactory(Task task) {
        if (!this.isMultiCore()) {
            throw new IllegalStateException("Task factories are not supported when only one CPU core is used");
        }
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            if (this.taskFactories == null) {
                this.taskFactories = new CopyOnWriteArrayList<Factory>();
            }
            this.taskFactories.add(new Factory(task));
        }
        this.processFactories();
    }

    public synchronized boolean removeTaskFactory(Task task) {
        if (this.taskFactories == null) {
            return false;
        }
        boolean result = this.taskFactories.remove(new Factory(task));
        if (this.taskFactories.isEmpty()) {
            this.taskFactories = null;
        }
        return result;
    }

    public synchronized void removeSelfTaskFactory() {
        if (this.taskFactories == null) {
            return;
        }
        Factory factory = this.curFactory.get();
        if (factory == null) {
            throw new IllegalStateException("Not running a task factory");
        }
        this.taskFactories.remove(factory);
        if (this.taskFactories.isEmpty()) {
            this.taskFactories = null;
        }
    }

    private void processTask(boolean wait) {
        Task task = null;
        this.processFactories();
        if (wait) {
            try {
                task = this.taskQueue.take();
            }
            catch (InterruptedException ex) {
                if (!this.active) {
                    return;
                }
                ex.printStackTrace();
            }
        } else {
            task = this.taskQueue.poll();
        }
        if (task == null) {
            return;
        }
        try {
            task.run();
        }
        finally {
            task.setTerminated();
        }
    }

    private void processFactories() {
        List<Factory> factories = this.taskFactories;
        if (factories != null) {
            int taskQueueSize = this.taskQueue.size();
            while (factories != null && (taskQueueSize == 0 || taskQueueSize < this.queueSize - factories.size())) {
                for (Factory factory : factories) {
                    if (!factory.used.compareAndSet(false, true)) continue;
                    this.curFactory.set(factory);
                    factory.task.run();
                    this.curFactory.remove();
                    boolean success = factory.used.compareAndSet(true, false);
                    assert (success);
                    if (++taskQueueSize >= this.queueSize) break;
                }
                taskQueueSize = this.taskQueue.size();
                factories = this.taskFactories;
            }
        }
    }

    private void execute(Task task) {
        boolean nested = Thread.currentThread() instanceof PoolThread;
        if (nested) {
            while (!this.taskQueue.offer(task)) {
                this.processTask(false);
            }
        } else {
            try {
                this.taskQueue.put(task);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void executeAndWait(Task ... tasks) {
        if (this.poolSize <= 1) {
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task task = taskArray[n2];
                task.run();
                ++n2;
            }
        } else {
            CountDownLatch latch = new CountDownLatch(tasks.length);
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n3 = 0;
            while (n3 < n) {
                Task task = taskArray[n3];
                task.setLatch(latch);
                this.execute(task);
                ++n3;
            }
            this.waitFor(latch);
        }
    }

    public CountDownLatch submit(Task ... tasks) {
        if (this.poolSize <= 1) {
            Task[] taskArray = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task task = taskArray[n2];
                task.run();
                ++n2;
            }
            return null;
        }
        CountDownLatch latch = new CountDownLatch(tasks.length);
        Task[] taskArray = tasks;
        int n = tasks.length;
        int n3 = 0;
        while (n3 < n) {
            Task task = taskArray[n3];
            task.setLatch(latch);
            this.execute(task);
            ++n3;
        }
        return latch;
    }

    public void submitAsync(Task task) {
        if (this.poolSize <= 1) {
            task.run();
        } else {
            this.execute(task);
        }
    }

    public void submitFragment(Task task) {
        this.submitAsync(task);
    }

    public void waitFor(CountDownLatch latch) {
        if (latch == null) {
            return;
        }
        boolean nested = Thread.currentThread() instanceof PoolThread;
        try {
            if (nested) {
                while (!latch.await(0L, TimeUnit.NANOSECONDS)) {
                    this.processTask(false);
                }
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public int getPoolSize() {
        return Math.max(1, this.poolSize);
    }

    public boolean isMultiCore() {
        return this.poolSize > 1;
    }

    public int getIncommingQueueCapacity() {
        return this.queueSize;
    }

    public int getQueueSize() {
        return this.taskQueue.size();
    }

    public boolean isFull() {
        return this.taskQueue.size() >= this.queueSize;
    }

    public Set<Thread> getPoolThreads() {
        if (this.poolSize == 0) {
            return Collections.singleton(Thread.currentThread());
        }
        return new HashSet<Thread>(Arrays.asList(this.poolThreads));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeByEachThread(final Runnable runnable) {
        if (this.poolSize <= 1) {
            runnable.run();
            return;
        }
        Object object = this.eachThreadLock;
        synchronized (object) {
            final CountDownLatch startLatch = new CountDownLatch(this.poolSize);
            final CountDownLatch stopLatch = new CountDownLatch(1);
            final CountDownLatch finishLatch = new CountDownLatch(this.poolSize);
            int i = 0;
            while (i < this.poolSize) {
                Task task = new Task(){

                    public void run() {
                        runnable.run();
                        startLatch.countDown();
                        try {
                            stopLatch.await();
                        }
                        catch (InterruptedException ex) {
                            ex.printStackTrace();
                        }
                        finishLatch.countDown();
                    }
                };
                this.submitAsync(task);
                ++i;
            }
            try {
                startLatch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            stopLatch.countDown();
            try {
                finishLatch.await();
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void dispose() {
        this.active = false;
        if (this.poolThreads != null) {
            Thread[] threadArray = this.poolThreads;
            int n = this.poolThreads.length;
            int n2 = 0;
            while (n2 < n) {
                Thread t = threadArray[n2];
                t.interrupt();
                try {
                    t.join(3000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                if (t.isAlive()) {
                    Debug.warn("Failed to stop pool thread " + t.getName(), new Object[0]);
                }
                ++n2;
            }
        }
        this.poolThreads = null;
        this.taskQueue.clear();
    }

    static class Factory {
        public final Task task;
        public final AtomicBoolean used = new AtomicBoolean(false);

        public Factory(Task task) {
            this.task = task;
        }

        public int hashCode() {
            return this.task.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            Factory other = (Factory)obj;
            return this.task.equals(other.task);
        }
    }

    class PoolThread
    extends Thread {
        PoolThread() {
        }

        public void run() {
            while (ThreadPool.this.active) {
                ThreadPool.this.processTask(true);
            }
        }
    }
}

