/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils.numa;

import ch.tachyon.tunnel.utils.numa.Task0;
import ch.tachyon.tunnel.utils.numa.ThreadPool0;
import ch.tachyon.tunnel.utils.old.ConcurrentSerialSection;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SerialTask
extends Task0
implements Comparable<SerialTask> {
    private final ConcurrentSerialSection serialSection;
    private long clock = -1L;
    private static final AtomicLong idGen = new AtomicLong(0L);
    private final long id = idGen.getAndIncrement();

    public SerialTask(String name, ConcurrentSerialSection serialSection) {
        super(name);
        if (serialSection == null) {
            throw new NullPointerException();
        }
        this.serialSection = serialSection;
    }

    public SerialTask(String name, ConcurrentSerialSection serialSection, long clock) {
        this(name, serialSection);
        this.clock = clock;
    }

    public long getClock() {
        return this.clock;
    }

    public void setClock(long clock) {
        assert (!this.running.get()) : "Task is running!";
        assert (this.clock <= -1L) : "Task " + this + " not runned yet; should run clock " + this.clock + ", and request for clock " + clock;
        this.clock = clock;
    }

    public ConcurrentSerialSection getSerialSection() {
        return this.serialSection;
    }

    public final boolean canRun() {
        return this.serialSection.canEnter(this.clock);
    }

    @Override
    void execute() {
        assert (this.running.compareAndSet(false, true)) : "Task is already running";
        if (this.serialSection.tryEnter(this.clock)) {
            try {
                this.run();
            }
            finally {
                this.serialSection.leave();
            }
        } else {
            throw new IllegalStateException("This task cannot be run now. Task clock " + this.clock + ", serial section's clock " + this.serialSection.getClock());
        }
        Task0 nextTask = this.nextTask;
        this.clock = -2L;
        assert (this.running.compareAndSet(true, false)) : "Task was not running";
        if (nextTask != null) {
            ThreadPool0.submitNext(nextTask);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.clock ^ this.clock >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerialTask other = (SerialTask)obj;
        if (this.clock != other.clock) {
            return false;
        }
        return this.id == other.id;
    }

    @Override
    public int compareTo(SerialTask other) {
        if (this == other) {
            return 0;
        }
        if (this.clock < other.clock) {
            return -1;
        }
        if (this.clock > other.clock) {
            return 1;
        }
        if (this.id < other.id) {
            return -1;
        }
        if (this.id > other.id) {
            return 1;
        }
        assert (this == other) : "Two SerialTask cannot have the same clock";
        return 0;
    }

    @Override
    public String toString() {
        return "SerialTask [name=" + this.getName() + ", clock=" + this.clock + ", expected: " + this.serialSection.getClock() + ", next=" + (this.nextTask == null ? "null" : this.nextTask.name) + "]";
    }
}

