/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils.numa;

import ch.tachyon.tunnel.utils.numa.ThreadPool0;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Task0
implements Runnable {
    protected final String name;
    final AtomicBoolean running = new AtomicBoolean(false);
    Task0 nextTask;

    public Task0(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public abstract void run();

    public void setNextTask(Task0 nextTask) {
        this.nextTask = nextTask;
    }

    public Task0 getNextTask() {
        return this.nextTask;
    }

    void execute() {
        assert (this.running.compareAndSet(false, true)) : "Task is already running";
        this.run();
        Task0 nextTask = this.nextTask;
        assert (this.running.compareAndSet(true, false)) : "Task was not running";
        if (nextTask != null) {
            ThreadPool0.submitNext(nextTask);
        }
    }

    public String toString() {
        return "Task [name=" + this.name + ", nextTask=" + (this.nextTask == null ? "null" : this.nextTask.name) + "]";
    }
}

