/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils.numa;

import ch.tachyon.tunnel.utils.numa.SerialTask;
import ch.tachyon.tunnel.utils.numa.Task0;
import ch.tachyon.tunnel.utils.numa.ThreadPoolQueues0;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadPool0 {
    private static final int poolSize;
    private static final int incommingQueueCapacity;
    private static final int frontQueueCapacity;
    private static final int serialQueueCapacity;
    private static final ThreadPoolQueues0 taskQueue;
    private static final Thread[] poolThreads;
    private static volatile boolean active;

    static {
        active = true;
        int nbCores = Runtime.getRuntime().availableProcessors();
        poolSize = nbCores > 1 ? nbCores : 0;
        incommingQueueCapacity = nbCores * 2 + 10;
        frontQueueCapacity = nbCores * 2 + 10;
        serialQueueCapacity = nbCores * 2 + 10;
        taskQueue = new ThreadPoolQueues0(incommingQueueCapacity, frontQueueCapacity, serialQueueCapacity);
        poolThreads = new Thread[poolSize];
        int i = 0;
        while (i < poolThreads.length) {
            PoolThread t = new PoolThread();
            t.setDaemon(true);
            ThreadPool0.poolThreads[i] = t;
            t.setName("PoolThread0-" + i);
            t.start();
            ++i;
        }
    }

    private ThreadPool0() {
    }

    static void processTask(boolean wait) {
        Task0 task = null;
        if (wait) {
            try {
                task = taskQueue.take();
            }
            catch (InterruptedException ex) {
                if (!active) {
                    return;
                }
                ex.printStackTrace();
            }
        } else {
            task = taskQueue.poll();
            if (task == null) {
                return;
            }
        }
        task.execute();
    }

    private static void execute(Task0 task) {
        boolean nested = Thread.currentThread() instanceof PoolThread;
        if (nested) {
            while (!taskQueue.offer(task)) {
                ThreadPool0.processTask(false);
            }
        } else {
            try {
                taskQueue.put(task);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void submitFragment(Task0 ... tasks) {
        if (tasks.length == 0) {
            return;
        }
        if (poolSize <= 1) {
            Task0[] task0Array = tasks;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                Task0 task = task0Array[n2];
                task.nextTask = null;
                task.execute();
                ++n2;
            }
        } else {
            int i = 0;
            while (i < tasks.length - 1) {
                tasks[i].nextTask = tasks[i + 1];
                ++i;
            }
            ThreadPool0.submitFirst0(tasks[0]);
        }
    }

    public static void submitFirst(Task0 task) {
        if (poolSize <= 1) {
            task.nextTask = null;
            task.execute();
        } else {
            ThreadPool0.submitFirst0(task);
        }
    }

    private static void submitFirst0(Task0 task) {
        ThreadPool0.execute(task);
    }

    private static void submitFront(Task0 task) {
        taskQueue.putFront(task);
    }

    private static void submitSerial(SerialTask task) {
        taskQueue.addSerial(task);
    }

    static void submitNext(Task0 task) {
        assert (task != null);
        if (task instanceof SerialTask) {
            ThreadPool0.submitSerial((SerialTask)task);
        } else {
            ThreadPool0.submitFront(task);
        }
    }

    public static int getPoolSize() {
        return Math.max(1, poolSize);
    }

    public static int getIncommingQueueCapacity() {
        return incommingQueueCapacity;
    }

    public static int getFrontQueueCapacity() {
        return frontQueueCapacity;
    }

    public static int getSerialQueueCapacity() {
        return serialQueueCapacity;
    }

    public static int getMaxSerialSize() {
        return incommingQueueCapacity + serialQueueCapacity + frontQueueCapacity + poolSize;
    }

    public static int getMaxSkew() {
        return ThreadPool0.getMaxSerialSize() + incommingQueueCapacity + poolSize + frontQueueCapacity;
    }

    public static int getQueueSize() {
        return taskQueue.size();
    }

    public static Set<Thread> getPoolThreads() {
        if (poolSize == 0) {
            return Collections.singleton(Thread.currentThread());
        }
        return new HashSet<Thread>(Arrays.asList(poolThreads));
    }

    public static void executeByEachThread(final Runnable runnable) {
        if (poolSize <= 1) {
            runnable.run();
            return;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        int i = 0;
        while (i < poolSize) {
            Task0 task = new Task0("executeByEachThread " + i){

                public void run() {
                    runnable.run();
                    try {
                        latch.await();
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                }
            };
            ThreadPool0.submitFirst0(task);
            ++i;
        }
        latch.countDown();
    }

    public static void awaitTermination() {
        if (poolSize <= 1) {
            return;
        }
        taskQueue.awaitIdle();
    }

    public static void dispose() {
        active = false;
        Thread[] threadArray = poolThreads;
        int n = poolThreads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            t.interrupt();
            try {
                t.join(3000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        taskQueue.clear();
    }

    private static class PoolThread
    extends Thread {
        private PoolThread() {
        }

        public void run() {
            try {
                while (active) {
                    ThreadPool0.processTask(true);
                }
            }
            catch (Throwable ex) {
                taskQueue.dumpStatistics();
                ex.printStackTrace();
            }
        }
    }
}

