/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils.old;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundedPriorityBlockingQueue<E>
implements BlockingQueue<E> {
    private final PriorityBlockingQueue<E> target = new PriorityBlockingQueue();
    private final int capacity;
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();

    public BoundedPriorityBlockingQueue(int capacity) {
        this.capacity = capacity;
    }

    private void waitNotFull() {
        if (this.isFull()) {
            this.lock.lock();
            try {
                while (this.isFull()) {
                    this.notFull.awaitUninterruptibly();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean isFull() {
        return this.target.size() >= this.capacity;
    }

    private void notifyNotFull() {
        this.lock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int hashCode() {
        return this.target.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public E remove() {
        Object result = this.target.remove();
        this.notifyNotFull();
        return result;
    }

    @Override
    public E element() {
        return this.target.element();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BoundedPriorityBlockingQueue) {
            return this.target.equals(((BoundedPriorityBlockingQueue)obj).target);
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.target.addAll(c);
    }

    @Override
    public boolean add(E e) {
        if (this.isFull()) {
            throw new IllegalArgumentException("Queue is full");
        }
        return this.target.add(e);
    }

    @Override
    public boolean offer(E e) {
        if (this.isFull()) {
            return false;
        }
        return this.target.offer(e);
    }

    @Override
    public void put(E e) {
        this.waitNotFull();
        this.target.put(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E poll() {
        E result = this.target.poll();
        this.notifyNotFull();
        return result;
    }

    @Override
    public E take() throws InterruptedException {
        E result = this.target.take();
        this.notifyNotFull();
        return result;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.target.containsAll(c);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public E peek() {
        return this.target.peek();
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.target.removeAll(c);
    }

    @Override
    public int remainingCapacity() {
        return this.capacity - this.target.size();
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.target.remove(o);
        if (result) {
            this.notifyNotFull();
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.target.retainAll(c);
    }

    @Override
    public boolean contains(Object o) {
        return this.target.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.target.toArray();
    }

    public String toString() {
        return this.target.toString();
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.target.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        return this.target.drainTo(c, maxElements);
    }

    @Override
    public void clear() {
        this.target.clear();
        this.lock.lock();
        try {
            this.notFull.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.target.toArray(a);
    }

    @Override
    public Iterator<E> iterator() {
        return this.target.iterator();
    }
}

