/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils.old;

import java.util.concurrent.atomic.AtomicLong;

public class ConcurrentSerialSection {
    private final String name;
    private AtomicLong clock = new AtomicLong(0L);
    private long nextValue;

    public ConcurrentSerialSection(String name) {
        this.name = name;
    }

    public boolean canEnter(long threadClock) {
        return threadClock == this.clock.get();
    }

    public boolean tryEnter(long threadClock) {
        boolean result = this.clock.compareAndSet(threadClock, -1L);
        if (result) {
            this.nextValue = threadClock + 1L;
        }
        return result;
    }

    public void leave() {
        boolean result = this.clock.compareAndSet(-1L, this.nextValue);
        assert (result);
    }

    public long getClock() {
        return this.clock.get();
    }

    public String toString() {
        return "ConcurrentSerialSection [name=" + this.name + ", clock=" + this.clock + "]";
    }
}

