/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.utils.old;

import ch.tachyon.tunnel.utils.Utils;
import ch.tachyon.tunnel.utils.numa.Heap15;
import ch.tachyon.tunnel.utils.numa.Heap16;
import ch.tachyon.tunnel.utils.numa.IHeap;
import ch.tachyon.tunnel.utils.numa.SerialTask;
import ch.tachyon.tunnel.utils.numa.Task0;
import ch.tachyon.tunnel.utils.numa.ThreadPool0;
import ch.tachyon.tunnel.utils.old.ConcurrentSerialSection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ThreadPoolQueues2 {
    private final int parallelCapacity;
    private final ConcurrentLinkedQueue<Task0> backQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Task0> frontQueue = new ConcurrentLinkedQueue();
    private final AtomicInteger backSize = new AtomicInteger();
    private final AtomicInteger notEmptyWaiters = new AtomicInteger();
    private final AtomicInteger notFullWaiters = new AtomicInteger();
    private final Lock lock = new ReentrantLock();
    private final Condition notFull = this.lock.newCondition();
    private final Condition notEmpty = this.lock.newCondition();
    private final Condition inactive = this.lock.newCondition();
    private final int frontQueueCapacity;
    private final AtomicInteger frontSize = new AtomicInteger(0);
    private final AtomicInteger maxFrontSize = new AtomicInteger(0);
    private final int serialCapacity;
    private final AtomicInteger serialSize = new AtomicInteger(0);
    private final AtomicInteger maxSerialSize = new AtomicInteger(0);
    private final ConcurrentHashMap<ConcurrentSerialSection, IHeap<SerialTask>> serialMap = new ConcurrentHashMap(16, 0.75f, 1);
    private final AtomicInteger nbTotal = new AtomicInteger(0);
    private final AtomicInteger nbUnderflows = new AtomicInteger(0);
    private final AtomicInteger nbFrontOverflows = new AtomicInteger(0);
    private final AtomicInteger nbSerialOverflows = new AtomicInteger(0);

    public ThreadPoolQueues2(int parallelCapacity, int frontCapacity, int serialCapacity) {
        this.parallelCapacity = parallelCapacity;
        this.frontQueueCapacity = frontCapacity;
        this.serialCapacity = serialCapacity;
    }

    private void waitNotEmpty() {
        int newValue = this.notEmptyWaiters.incrementAndGet();
        if (newValue >= ThreadPool0.getPoolSize()) {
            this.inactive.signalAll();
        }
        this.notEmpty.awaitUninterruptibly();
        this.notEmptyWaiters.getAndDecrement();
    }

    private void notifyNotEmpty() {
        if (this.notEmptyWaiters.get() > 0) {
            this.lock.lock();
            try {
                this.notEmpty.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void waitNotFull() {
        this.notFullWaiters.getAndIncrement();
        this.notFull.awaitUninterruptibly();
        this.notFullWaiters.getAndDecrement();
    }

    private void notifyNotFull() {
        if (this.notFullWaiters.get() > 0) {
            this.lock.lock();
            try {
                this.notFull.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void put(Task0 task) throws InterruptedException {
        boolean success = this.offer(task);
        if (!success) {
            this.lock.lock();
            try {
                success = this.offer(task);
                while (!success) {
                    this.waitNotFull();
                    success = this.offer(task);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    protected boolean offer(Task0 task) {
        int newSize = this.backSize.incrementAndGet();
        if (newSize > this.parallelCapacity) {
            this.backSize.decrementAndGet();
            return false;
        }
        this.backQueue.add(task);
        this.notifyNotEmpty();
        this.nbTotal.incrementAndGet();
        return true;
    }

    public void putFront(Task0 task) {
        while (this.frontSize.get() >= this.frontQueueCapacity) {
            this.lock.lock();
            try {
                this.waitNotFull();
            }
            finally {
                this.lock.unlock();
            }
        }
        int oldSize = this.frontSize.getAndIncrement();
        this.maxFrontSize.compareAndSet(oldSize, oldSize + 1);
        this.frontQueue.add(task);
    }

    public void addSerial(SerialTask task) {
        IHeap<SerialTask> previous;
        while (this.serialSize.get() >= this.serialCapacity) {
            this.lock.lock();
            try {
                this.waitNotFull();
            }
            finally {
                this.lock.unlock();
            }
        }
        int newSize = this.serialSize.getAndIncrement();
        this.maxSerialSize.compareAndSet(newSize - 1, newSize);
        ConcurrentSerialSection section = task.getSerialSection();
        IHeap<SerialTask> queue = this.serialMap.get(section);
        if (queue == null && (previous = this.serialMap.putIfAbsent(section, queue = Utils.isBelowJava16() ? new Heap15<SerialTask>() : new Heap16<SerialTask>())) != null) {
            queue = previous;
        }
        queue.add(task);
    }

    public Task0 take() throws InterruptedException {
        Task0 result = this.poll();
        if (result == null) {
            this.lock.lock();
            try {
                result = this.poll();
                while (result == null) {
                    if (this.serialSize.get() > 0) {
                        this.nbSerialOverflows.getAndIncrement();
                    } else {
                        this.nbUnderflows.getAndIncrement();
                    }
                    this.waitNotEmpty();
                    result = this.poll();
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return result;
    }

    public Task0 poll() {
        for (IHeap<SerialTask> queue : this.serialMap.values()) {
            SerialTask polledTask;
            SerialTask peekedTask = queue.peekFirst();
            if (peekedTask == null || !peekedTask.canRun() || (polledTask = queue.pollFirst()) == null) continue;
            if (polledTask.canRun()) {
                this.serialSize.decrementAndGet();
                this.notifyNotFull();
                return polledTask;
            }
            queue.add(polledTask);
        }
        Task0 result = this.frontQueue.poll();
        if (result != null) {
            this.frontSize.decrementAndGet();
            this.notifyNotFull();
            return result;
        }
        result = this.backQueue.poll();
        if (result != null) {
            this.backSize.decrementAndGet();
            this.notifyNotFull();
        }
        return result;
    }

    public int size() {
        return this.backQueue.size();
    }

    /*
     * Exception decompiling
     */
    public void awaitIdle() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void clear() {
        this.backQueue.clear();
        this.frontQueue.clear();
        this.serialMap.clear();
    }
}

