/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base;

import org.corebounce.common.math.Cmplx;

public class AuditoryScales {
    public static final int NB_BARKS = 24;
    public static final float[] BARK_EDGES = new float[]{0.0f, 100.0f, 200.0f, 300.0f, 400.0f, 510.0f, 630.0f, 770.0f, 920.0f, 1080.0f, 1270.0f, 1480.0f, 1720.0f, 2000.0f, 2320.0f, 2700.0f, 3150.0f, 3700.0f, 4400.0f, 5300.0f, 6400.0f, 7700.0f, 9500.0f, 12000.0f, 15500.0f};
    public static final float[] BARK_WIDTH = new float[]{100.0f, 100.0f, 100.0f, 100.0f, 110.0f, 120.0f, 140.0f, 150.0f, 160.0f, 190.0f, 210.0f, 240.0f, 280.0f, 320.0f, 380.0f, 450.0f, 550.0f, 700.0f, 900.0f, 1100.0f, 1300.0f, 1800.0f, 2500.0f, 3500.0f};
    public static final float[] BARK_CENTERS = new float[]{50.0f, 150.0f, 250.0f, 350.0f, 450.0f, 570.0f, 700.0f, 840.0f, 1000.0f, 1170.0f, 1370.0f, 1600.0f, 1850.0f, 2150.0f, 2500.0f, 2900.0f, 3400.0f, 4000.0f, 4800.0f, 5800.0f, 7000.0f, 8500.0f, 10500.0f, 13500.0f};

    public static double frequencyToMel(double frequency) {
        return 1127.0 * Math.log(1.0 + frequency / 700.0);
    }

    public static double melToFrequency(double mel) {
        return 700.0 * (Math.exp(mel / 1127.0) - 1.0);
    }

    public static double frequencyToBark(double frequency) {
        return 13.0 * Math.atan(7.6E-4 * frequency) + 3.5 * Math.atan(AuditoryScales.sq(frequency / 7500.0));
    }

    public static double frequencyToBark2(double frequency) {
        return 7.0 * Cmplx.asinh((double)(frequency / 650.0));
    }

    public static double barkToFrequency(double bark) {
        return 650.0 * Math.sinh(bark / 7.0);
    }

    private static double sq(double v) {
        return v * v;
    }

    public static float test(float value) {
        return (float)(0.4 + 0.26 * Math.atan(4.0 * Math.log(0.1 * (double)value) - 18.0));
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 200) {
            System.out.println(AuditoryScales.melToFrequency(i * 20));
            ++i;
        }
    }
}

