/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.Dish;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.LockedMultiScaleFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public class AdaptiveFourierEngine
implements IFourierEngine {
    private static final float NOISE_AMPLIFICATION = 1.5f;
    private static final String DELAYER_SERIAL_SECTION_NAME = String.valueOf(LockedMultiScaleFourierEngine.class.getName()) + " delayer";
    private FourierSpec specs;
    private float[][] mChan;
    private Fork fork;
    private Dish dish;
    private int inChunkSize;
    private int outChunkSize;
    private int nbScales;
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;
    private float[] output;
    private float[] lockedOutput;
    private ConcurrentDelayBuffer orgDelayer;
    private ISerialSection orgDelayerSection;
    private PyramidAnalyzer orgAnalyzer;
    private float[] delayed;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void startProcessing(IProcessingInfo info) {
        int overlap = (int)(this.specs.getOverlap() + 0.5f);
        this.inChunkSize = this.specs.getInputHopSize();
        this.outChunkSize = this.specs.getOutputHopSize();
        int outOverlap = (int)((float)overlap / this.specs.getTimeScale() + 0.5f);
        int[] scales = this.specs.getScales();
        this.nbScales = scales.length;
        this.fork = new Fork(1, this.specs.getSharpInfoSplit(), this.inChunkSize, false, this.specs.getNoiseMode(), 1.5f);
        this.dish = new Dish(this.specs.getAdaptiveResolutions(), this.specs.getSplitFreqs(), this.specs.getNoiseSplitFreqs(), this.fork.getInputSize(), AudioMath.adjustPowerOf2((int)512, (float)44100.0f, (float)info.getSampleRate()), info.getSampleRate());
        this.analyzer = new PyramidAnalyzer(scales, this.inChunkSize, overlap, this.specs.getAnalysisWindow());
        this.synthesizer = new PyramidSynthesizer(scales, this.outChunkSize, outOverlap, this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getPostFftProcessor(), this.specs.getSynthesisShrink(), this.specs.getEnergyCorrection(), this.specs.getTimeScale());
        this.synthesizer.setFourierLatency(this.specs.getFourierLatency());
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            int[] orgScales = scales;
            if (!this.specs.getRequiresSource()) {
                orgScales = new int[scales.length - 1];
                System.arraycopy(scales, 0, orgScales, 0, orgScales.length);
            }
            this.orgAnalyzer = new PyramidAnalyzer("orginal", orgScales, this.inChunkSize, overlap, this.specs.getAnalysisWindow());
        }
    }

    private void setupOrgDelayer(IMtContext mtContext) {
        int delayAmount = this.fork.getLatency() + this.dish.getLatency();
        int inputSize = this.fork.getInputSize();
        this.orgDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + inputSize * mtContext.getSerialRunningMaxSkew(), inputSize);
    }

    public int getFixedChunkLength() {
        return this.inChunkSize;
    }

    public int getLatency() {
        int result = (int)((float)(this.fork.getLatency() + this.dish.getLatency()) * this.specs.getTimeScale() + 0.5f) + this.synthesizer.getLatency();
        return result += (int)((float)this.synthesizer.getBaseBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
    }

    public int getNbScales() {
        return this.specs.getNbScales();
    }

    public int getNbResolutions() {
        return this.specs.getNbScales();
    }

    public int getNbBins() {
        return -1;
    }

    public int getNbBins(int layer) {
        return this.specs.getScales()[layer] / 2 + 1;
    }

    public int getEffectiveResolution(int layer) {
        return (int)(this.specs.getSharpInfo().layerInfo[layer].getAnalysisResolution() + 0.5f);
    }

    public int getNumHops(int layer) {
        return this.analyzer.getNumHops(layer);
    }

    public int getInputHopSize() {
        return this.analyzer.getInputSize();
    }

    public int getDistanceBetweenFrames(int res) {
        return this.analyzer.getBlockSize(res) / this.analyzer.getOverlap();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.mChan = new float[1][];
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.delayed = new float[this.inChunkSize];
        }
        if (this.inChunkSize != this.outChunkSize) {
            this.output = new float[this.outChunkSize];
        }
        if (this.specs.getPostLockedProcessor() != null) {
            this.lockedOutput = new float[this.outChunkSize];
        }
        this.fork.init();
        this.dish.init();
        this.analyzer.init();
        this.synthesizer.init();
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgAnalyzer.init();
        }
    }

    public float[] process(float[] input, ISpectrumProcessor processor) {
        float[] output;
        this.mChan[0] = input;
        this.fork.process(this.mChan);
        float[][] layers = this.fork.getOutputs(0);
        float[][] scales = this.dish.process(layers);
        assert (scales.length == this.nbScales);
        int i = 0;
        while (i < this.nbScales / 2) {
            float[] temp = scales[i];
            scales[i] = scales[this.nbScales - i - 1];
            scales[this.nbScales - i - 1] = temp;
            ++i;
        }
        Cmplx[][][] orgSpectrums = null;
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            long delayerClock = this.orgDelayerSection.getClock();
            this.orgDelayer.push(input, delayerClock);
            this.orgDelayerSection.sync();
            this.orgDelayer.pop(this.delayed, delayerClock);
            orgSpectrums = this.orgAnalyzer.analyzeInEachRes(this.delayed);
        }
        long clock = this.analyzer.getClock();
        Cmplx[][][] spectrums = this.analyzer.analyze(scales);
        if (this.specs.getAntiLeakage()) {
            int r = 0;
            while (r < this.nbScales - 1) {
                if (r >= this.specs.getNbUnLockedScales()) {
                    int k = 0;
                    while (k < spectrums[r].length) {
                        Cmplx[] orgSpectrum = orgSpectrums[r][k];
                        Cmplx[] spectrum = spectrums[r][k];
                        int i2 = 0;
                        while (i2 < spectrum.length) {
                            float sigMag = spectrum[i2].magApprox();
                            float orgMag = orgSpectrum[i2].magApprox();
                            if (orgMag < sigMag) {
                                spectrum[i2].mul(orgMag / sigMag);
                            }
                            ++i2;
                        }
                        ++k;
                    }
                }
                ++r;
            }
        }
        int step = 0;
        while (step < processor.getNumSteps()) {
            int r = 0;
            while (r < spectrums.length) {
                Cmplx[][] sources = this.specs.getRequiresSource() ? orgSpectrums[r] : spectrums[r];
                Cmplx[][] frames = spectrums[r];
                int numHops = this.analyzer.getNumHops(r);
                assert (frames.length == numHops && sources.length == numHops);
                int k = 0;
                while (k < frames.length) {
                    processor.process(r, r, sources[k], frames[k], k, clock * (long)numHops + (long)k, step);
                    ++k;
                }
                ++r;
            }
            processor.afterStep(step, clock);
            ++step;
        }
        float[] fArray = output = this.output == null ? input : this.output;
        if (this.specs.getPostLockedProcessor() == null) {
            this.synthesizer.synthesize(spectrums, output);
        } else {
            this.synthesizer.synthesize(spectrums, output, this.specs.getNbUnLockedScales(), this.lockedOutput);
            this.specs.getPostLockedProcessor().postProcess(this.lockedOutput, output);
            int i3 = 0;
            while (i3 < this.lockedOutput.length) {
                int n = i3;
                output[n] = output[n] + this.lockedOutput[i3];
                ++i3;
            }
        }
        return output;
    }

    public void stopProcessing() {
        this.mChan = null;
        this.fork = null;
        this.dish = null;
        this.analyzer = null;
        this.synthesizer = null;
        this.orgDelayer = null;
        this.orgAnalyzer = null;
        this.delayed = null;
        this.output = null;
        this.specs = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.fork.createSerialSections(factory);
        this.dish.createSerialSections(factory);
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.setupOrgDelayer(factory.getMtContext());
            this.orgDelayerSection = factory.createSerialSection(DELAYER_SERIAL_SECTION_NAME, (Object)this.orgDelayer);
            this.orgAnalyzer.createSerialSections(factory);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.fork.setSerialSections(pool);
        this.dish.setSerialSections(pool);
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgDelayerSection = pool.getSerialSection(DELAYER_SERIAL_SECTION_NAME);
            this.orgDelayer = (ConcurrentDelayBuffer)this.orgDelayerSection.getUserData();
            this.orgAnalyzer.setSerialSections(pool);
        }
    }
}

