/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.fourier.IPostFftProcessor;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public class Cup
implements IHasSerialSections {
    private final StftSynthesizerMulti synthesizer;
    private final float[] outBlock;
    private final float analysisShrink;
    private final boolean enableEnergyCorrection;

    public Cup(SharpInfo info, int layer, IPostFftProcessor postFftProcessor) {
        this("cup" + layer, info.blockSize, info.hopSize, info.layerInfo[layer].analysisShrink, info.layerInfo[layer].synthesisShrink, info.layerInfo[layer].enableEnergyCorrection, postFftProcessor);
    }

    public Cup(String name, int blockSize, int hopSize, float analysisShrink, float synthesisShrink, boolean energyCorrection, final IPostFftProcessor postFftProcessor) {
        this.analysisShrink = analysisShrink;
        this.enableEnergyCorrection = energyCorrection;
        float[] analysisWindow = WindowsFactory.getHannWindow(blockSize, analysisShrink, energyCorrection);
        final float[] synthesisWindow = WindowsFactory.getHannWindow(blockSize, synthesisShrink);
        this.synthesizer = new StftSynthesizerMulti(blockSize, hopSize, 1, analysisWindow, synthesisWindow){

            protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                super.backwardFFT(spectrum, output);
                if (postFftProcessor != null) {
                    postFftProcessor.postProcess(output);
                }
            }

            protected void applySynthesisWindow(float[] output) {
                Cup.this.applySynthesisWindowWithEnergyCorrection(output, synthesisWindow);
            }
        };
        this.synthesizer.setName(name);
        this.outBlock = new float[hopSize];
    }

    public int getHopSize() {
        return this.outBlock.length;
    }

    void applySynthesisWindowWithEnergyCorrection(float[] output, float[] synthesisWindow) {
        float energyCorrection = 1.0f;
        if (this.analysisShrink > 1.0f && this.enableEnergyCorrection) {
            float maxCorrection = (float)Math.sqrt(this.analysisShrink);
            int blockSize = output.length;
            int cellSize = (int)((float)blockSize / this.analysisShrink + 0.5f);
            int cellStart = (blockSize - cellSize) / 2;
            int cellStop = cellStart + cellSize;
            float cellEnergy = 0.0f;
            float blockEnergy = 0.0f;
            int i = 0;
            while (i < blockSize) {
                float p = output[i] * output[i];
                blockEnergy += p;
                if (i >= cellStart && i < cellStop) {
                    cellEnergy += p;
                }
                ++i;
            }
            if (cellEnergy > 0.0f && (energyCorrection = (float)Math.sqrt(blockEnergy / cellEnergy)) > maxCorrection) {
                energyCorrection = maxCorrection;
            }
        }
        int i = 0;
        while (i < output.length) {
            int n = i;
            output[n] = output[n] * (synthesisWindow[i] * energyCorrection);
            ++i;
        }
    }

    public void init() {
        this.synthesizer.init();
    }

    public int getLatency() {
        return this.synthesizer.getLatency();
    }

    public int getBlockSize() {
        return this.synthesizer.getBlockSize();
    }

    public void processAdd(Cmplx[] spectrum, float[] output) {
        if (output.length != this.synthesizer.getHopSize()) {
            throw new IllegalArgumentException();
        }
        Cmplx[][] mFrames = new Cmplx[][]{spectrum};
        this.synthesizer.synthesize(mFrames, this.outBlock);
        int i = 0;
        while (i < this.outBlock.length) {
            int n = i;
            output[n] = output[n] + this.outBlock[i];
            ++i;
        }
    }

    public void preProcessAdd(Cmplx[] spectrum, long clock) {
        Cmplx[][] mFrames = new Cmplx[][]{spectrum};
        this.synthesizer.preSynthesize(mFrames, clock);
    }

    public void postProcessAdd(float[] output, long clock) {
        if (output.length != this.synthesizer.getHopSize()) {
            throw new IllegalArgumentException();
        }
        this.synthesizer.renderResult(this.outBlock, clock);
        int i = 0;
        while (i < this.outBlock.length) {
            int n = i;
            output[n] = output[n] + this.outBlock[i];
            ++i;
        }
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.synthesizer.setSerialSections(pool);
    }
}

