/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import org.corebounce.common.audio.AudioMath;

public class KnifeInfo {
    private static final float BASE_SAMPLE_RATE = 44100.0f;
    public final int blockSize;
    public final int hopSize;
    public final int minimizerLength;
    public final int averagerLength;
    public final int minSpan;
    public final int spread;
    public final double sensivityDb;
    public final double attackSpeedDb;
    public final boolean hard;

    public KnifeInfo(int blockSize, int hopSize, int minimizerLength, int averagerLength, int minSpan, int spread, double sensivityDb, double attackSpeedDb, boolean hard) {
        if (!KnifeInfo.isPowerOf2(blockSize) || !KnifeInfo.isPowerOf2(hopSize) || hopSize >= blockSize) {
            throw new IllegalArgumentException("Invalid STFT parameters");
        }
        if (minimizerLength <= 0 || averagerLength <= 0) {
            throw new IllegalArgumentException();
        }
        if (minSpan < 0 || spread < 0) {
            throw new IllegalArgumentException();
        }
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.minimizerLength = minimizerLength;
        this.averagerLength = averagerLength;
        this.minSpan = minSpan;
        this.spread = spread;
        this.sensivityDb = sensivityDb;
        this.attackSpeedDb = attackSpeedDb;
        this.hard = hard;
    }

    public static KnifeInfo getInstance(int transience, float sampleRate) {
        if (transience == 0) {
            return new KnifeInfo(AudioMath.adjustPowerOf2((int)128, (float)44100.0f, (float)sampleRate), AudioMath.adjustPowerOf2((int)32, (float)44100.0f, (float)sampleRate), 24, 20, 15, 3, 6.0, 1.0, false);
        }
        if (transience == 1) {
            return new KnifeInfo(AudioMath.adjustPowerOf2((int)512, (float)44100.0f, (float)sampleRate), AudioMath.adjustPowerOf2((int)128, (float)44100.0f, (float)sampleRate), 24, 20, 10, 3, 5.0, 3.0, false);
        }
        if (transience == 2) {
            return new KnifeInfo(AudioMath.adjustPowerOf2((int)2048, (float)44100.0f, (float)sampleRate), AudioMath.adjustPowerOf2((int)512, (float)44100.0f, (float)sampleRate), 12, 10, 2, 0, 1.5, 5.0, false);
        }
        throw new IllegalArgumentException();
    }

    public KnifeInfo copyWithHopSize(int newHopSize) {
        KnifeInfo result = new KnifeInfo(this.blockSize, newHopSize, this.minimizerLength * this.hopSize / newHopSize, this.averagerLength * this.hopSize / newHopSize, this.minSpan, this.spread, this.sensivityDb, this.attackSpeedDb * (double)newHopSize / (double)this.hopSize, this.hard);
        return result;
    }

    private static boolean isPowerOf2(int value) {
        return value >= 2 && (value & value - 1) == 0;
    }

    public String toString() {
        return "KnifeInfo[" + this.hopSize + ":" + this.blockSize + "]";
    }
}

