/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

public class LayerInfo {
    public final int blockSize;
    public final int hopSize;
    public final float analysisShrink;
    public final float synthesisShrink;
    public final boolean enableEnergyCorrection;

    public LayerInfo(int blockSize, int hopSize, float analysisShrink, float synthesisShrink, boolean enableEnergyCorrection) {
        if (!LayerInfo.isPowerOf2(blockSize) || !LayerInfo.isPowerOf2(hopSize) || hopSize >= blockSize) {
            throw new IllegalArgumentException("Invalid STFT parameters");
        }
        if (analysisShrink < 1.0f || analysisShrink >= (float)blockSize) {
            throw new IllegalArgumentException("Invalid analysis shrink");
        }
        if (synthesisShrink < 1.0f || synthesisShrink >= (float)blockSize) {
            throw new IllegalArgumentException("Invalid synthesis shrink");
        }
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.analysisShrink = analysisShrink;
        this.synthesisShrink = synthesisShrink;
        this.enableEnergyCorrection = enableEnergyCorrection;
    }

    private static boolean isPowerOf2(int value) {
        return value >= 2 && (value & value - 1) == 0;
    }

    public int getCeilFftSize() {
        float resolution = this.getAnalysisResolution();
        int result = 1;
        while ((float)result < resolution) {
            result *= 2;
        }
        return result;
    }

    public float getAnalysisResolution() {
        return (float)this.blockSize / this.analysisShrink;
    }

    public String toString() {
        return "LayerInfo[" + this.blockSize + ":" + this.hopSize + "/(" + this.analysisShrink + "|" + this.synthesisShrink + ")]";
    }
}

