/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.Cup;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.Spoon;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public class LockedMultiScaleFourierEngine
implements IFourierEngine {
    private static final String SPOON_SERIAL_SECTION_NAME = String.valueOf(LockedMultiScaleFourierEngine.class.getName()) + " spoon";
    private static final String CUP_SERIAL_SECTION_NAME = String.valueOf(LockedMultiScaleFourierEngine.class.getName()) + " cup";
    private static final String DELAYER_SERIAL_SECTION_NAME = String.valueOf(LockedMultiScaleFourierEngine.class.getName()) + " delayer";
    private FourierSpec specs;
    private int nbBins;
    private float[][] mChan;
    private Fork fork;
    private Spoon[] spoons;
    private ConcurrentDelayBuffer orgDelayer;
    private Spoon[] orgSpoons;
    private Cup[] cups;
    private Cmplx[][] spectrums;
    private Cmplx[][] orgSpectrums;
    private Cmplx[] source;
    private float[] sourcePhi;
    private float[] delayed;
    private ISerialSection spoonSerialSection;
    private ISerialSection cupSerialSection;
    private ISerialSection delayerSerialSection;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void startProcessing(IProcessingInfo info) {
        this.fork = new Fork(1, this.specs.getSharpInfo());
        int nbLayers = this.specs.getNbLayers();
        this.spoons = new Spoon[nbLayers];
        this.orgSpoons = new Spoon[nbLayers];
        this.cups = new Cup[nbLayers];
        int i = 0;
        while (i < nbLayers) {
            this.spoons[i] = new Spoon(this.specs.getSharpInfo(), i);
            if (i > 0 && this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
                this.orgSpoons[i] = new Spoon("org", this.specs.getSharpInfo(), i);
            }
            this.cups[i] = new Cup(this.specs.getSharpInfoOut(), i, this.specs.getPostFftProcessor());
            ++i;
        }
    }

    private void setupSrcDelayer(IMtContext mtContext) {
        int delayAmount = this.fork.getLatency();
        int inputSize = this.fork.getInputSize();
        this.orgDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + inputSize * mtContext.getSerialRunningMaxSkew(), inputSize);
    }

    public int getFixedChunkLength() {
        return this.fork.getInputSize();
    }

    public int getLatency() {
        int result = (int)((float)this.fork.getLatency() * this.specs.getTimeScale() + 0.5f) + this.cups[0].getLatency();
        if (this.specs.getFourierLatency() != null) {
            result += this.specs.getFourierLatency().getFourierLatency(this.getDistanceBetweenFrames(0), 0, 0);
        }
        return result += (int)((float)this.cups[0].getBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
    }

    public int getNbScales() {
        return this.specs.getNbLayers();
    }

    public int getNbResolutions() {
        return 1;
    }

    public int getNbBins(int layer) {
        return this.getNbBins();
    }

    public int getNbBins() {
        return this.specs.getBaseResolution() / 2 + 1;
    }

    public int getEffectiveResolution(int layer) {
        return (int)(this.specs.getSharpInfo().layerInfo[layer].getAnalysisResolution() + 0.5f);
    }

    public int getNumHops(int scale) {
        return 1;
    }

    public int getInputHopSize() {
        return this.specs.getSharpInfo().hopSize;
    }

    public int getDistanceBetweenFrames(int res) {
        return this.specs.getSharpInfo().hopSize;
    }

    public void beginProcessing(IProcessingInfo info) {
        Spoon spoon;
        this.mChan = new float[1][];
        this.nbBins = this.specs.getSharpInfo().blockSize / 2 + 1;
        int nbLayers = this.specs.getNbLayers();
        this.spectrums = new Cmplx[nbLayers][];
        this.orgSpectrums = new Cmplx[nbLayers][];
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.delayed = new float[this.fork.getInputSize()];
            this.source = Cmplx.newArray((int)this.nbBins);
            this.sourcePhi = new float[this.nbBins];
        }
        this.fork.init();
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            spoon.init();
            ++n2;
        }
        objectArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            if (spoon != null) {
                spoon.init();
            }
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).init();
            ++n2;
        }
    }

    public float[] process(float[] data, ISpectrumProcessor processor) {
        int scale;
        this.mChan[0] = data;
        this.fork.process(this.mChan);
        int nbLayers = this.specs.getNbLayers();
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            long delayerClock = this.delayerSerialSection.getClock();
            this.orgDelayer.push(data, delayerClock);
            this.delayerSerialSection.sync();
            this.orgDelayer.pop(this.delayed, delayerClock);
        }
        int scale2 = 0;
        while (scale2 < nbLayers) {
            this.spoons[scale2].preProcess(this.fork.getOutput(scale2, 0), this.spoonSerialSection.getClock());
            ++scale2;
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            scale2 = 0;
            while (scale2 < nbLayers) {
                if (this.orgSpoons[scale2] != null) {
                    this.orgSpoons[scale2].preProcess(this.delayed, this.spoonSerialSection.getClock());
                }
                ++scale2;
            }
        }
        long clock = this.spoonSerialSection.getClock();
        this.spoonSerialSection.sync();
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            scale = 0;
            while (scale < nbLayers) {
                if (this.orgSpoons[scale] != null) {
                    this.orgSpectrums[scale] = this.orgSpoons[scale].postProcess();
                }
                ++scale;
            }
        }
        scale = 0;
        while (scale < nbLayers) {
            this.spectrums[scale] = this.spoons[scale].postProcess();
            ++scale;
        }
        if (this.specs.getAntiLeakage()) {
            int r = 1;
            while (r < nbLayers) {
                Cmplx[] orgSpectrum = this.orgSpectrums[r];
                Cmplx[] spectrum = this.spectrums[r];
                int i = 0;
                while (i < spectrum.length) {
                    float sigMag = spectrum[i].magApprox();
                    float srcMag = orgSpectrum[i].magApprox();
                    if (srcMag < sigMag) {
                        spectrum[i].mul(srcMag / sigMag);
                    }
                    ++i;
                }
                ++r;
            }
            this.fillAveragedPhases(this.spectrums);
            this.lockPhases(this.spectrums);
        }
        int step = 0;
        while (step < processor.getNumSteps()) {
            int layer = 0;
            while (layer < this.spectrums.length) {
                Cmplx[] analyzeSpectrum = this.specs.getRequiresSource() ? this.orgSpectrums[layer] : this.spectrums[layer];
                processor.process(0, layer, analyzeSpectrum, this.spectrums[layer], 0, clock, step);
                ++layer;
            }
            processor.afterStep(step, clock);
            ++step;
        }
        Arrays.fill(data, 0.0f);
        long cupClock = this.cupSerialSection.getClock();
        int scale3 = 0;
        while (scale3 < nbLayers) {
            this.cups[scale3].preProcessAdd(this.spectrums[scale3], cupClock);
            ++scale3;
        }
        this.cupSerialSection.sync();
        scale3 = 0;
        while (scale3 < nbLayers) {
            this.cups[scale3].postProcessAdd(data, cupClock);
            ++scale3;
        }
        return data;
    }

    private void fillAveragedPhases(Cmplx[][] spectrums) {
        Cmplx[] spectrum = spectrums[0];
        int i = 0;
        while (i < this.nbBins) {
            this.source[i].set(spectrum[i]);
            ++i;
        }
        int scale = 1;
        while (scale < this.specs.getNbLayers()) {
            Cmplx[] spectrum2 = spectrums[scale];
            int i2 = 0;
            while (i2 < this.nbBins) {
                this.source[i2].add(spectrum2[i2]);
                ++i2;
            }
            ++scale;
        }
        int i3 = 0;
        while (i3 < this.nbBins) {
            this.sourcePhi[i3] = this.source[i3].phiApprox();
            ++i3;
        }
    }

    private void lockPhases(Cmplx[][] spectrums) {
        Cmplx[][] cmplxArray = spectrums;
        int n = spectrums.length;
        int n2 = 0;
        while (n2 < n) {
            Cmplx[] spectrum = cmplxArray[n2];
            int i = 0;
            while (i < this.nbBins) {
                Cmplx value = spectrum[i];
                float srcPhi = this.sourcePhi[i];
                value.toPolarApprox();
                value.im = srcPhi;
                value.toCartesianApprox();
                ++i;
            }
            ++n2;
        }
    }

    public void stopProcessing() {
        this.mChan = null;
        this.fork = null;
        this.spoons = null;
        this.orgSpoons = null;
        this.orgDelayer = null;
        this.delayed = null;
        this.cups = null;
        this.spectrums = null;
        this.orgSpectrums = null;
        this.source = null;
        this.sourcePhi = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        Spoon spoon;
        this.fork.createSerialSections(factory);
        this.spoonSerialSection = factory.createSerialSection(SPOON_SERIAL_SECTION_NAME, null);
        this.cupSerialSection = factory.createSerialSection(CUP_SERIAL_SECTION_NAME, null);
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            spoon.createSerialSections(factory);
            ++n2;
        }
        objectArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            if (spoon != null) {
                spoon.createSerialSections(factory);
            }
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).createSerialSections(factory);
            ++n2;
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.setupSrcDelayer(factory.getMtContext());
            this.delayerSerialSection = factory.createSerialSection(DELAYER_SERIAL_SECTION_NAME, (Object)this.orgDelayer);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        Spoon spoon;
        this.fork.setSerialSections(pool);
        this.spoonSerialSection = pool.getSerialSection(SPOON_SERIAL_SECTION_NAME);
        this.cupSerialSection = pool.getSerialSection(CUP_SERIAL_SECTION_NAME);
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            spoon.setSerialSections(pool);
            ++n2;
        }
        objectArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            if (spoon != null) {
                spoon.setSerialSections(pool);
            }
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).setSerialSections(pool);
            ++n2;
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.delayerSerialSection = pool.getSerialSection(DELAYER_SERIAL_SECTION_NAME);
            this.orgDelayer = (ConcurrentDelayBuffer)this.delayerSerialSection.getUserData();
        }
    }
}

