/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.AverageBuffer;
import org.corebounce.common.dsp.MaxBuffer;
import org.corebounce.common.math.Cmplx;

public class MinAvgSpectrumBuffer {
    private static final float THRESHOLD = (float)AudioMath.dbToLevel((double)-80.0);
    private int nbBins;
    private int length;
    private MaxBuffer[] minAvgBuffers;
    private AverageBuffer[] avgLevels;

    public MinAvgSpectrumBuffer(int nbBins, int length, int avgLength) {
        this.setSize(nbBins, length, avgLength);
    }

    public void setSize(int nbBins, int length, int avgLength) {
        this.nbBins = nbBins;
        this.length = length;
        this.minAvgBuffers = new MaxBuffer[nbBins];
        this.avgLevels = new AverageBuffer[nbBins];
        int i = 0;
        while (i < this.minAvgBuffers.length) {
            this.minAvgBuffers[i] = new MaxBuffer(length, -THRESHOLD);
            this.avgLevels[i] = new AverageBuffer(avgLength);
            int k = 0;
            while (k < avgLength) {
                this.avgLevels[i].push(THRESHOLD);
                ++k;
            }
            ++i;
        }
    }

    public void push(Cmplx[] spectrum) {
        if (spectrum.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < spectrum.length) {
            float level = spectrum[i].magApprox();
            this.avgLevels[i].push(level);
            level = this.avgLevels[i].getAverage();
            this.minAvgBuffers[i].push(-level);
            ++i;
        }
    }

    public void push(float[] levels) {
        if (levels.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < levels.length) {
            float level = levels[i];
            this.avgLevels[i].push(level);
            level = this.avgLevels[i].getAverage();
            this.minAvgBuffers[i].push(-level);
            ++i;
        }
    }

    public float getAvgLevel(int binNum) {
        return this.avgLevels[binNum].getAverage();
    }

    public float getMinAvgLevel(int binNum) {
        float result = -this.minAvgBuffers[binNum].getMax();
        if (result < THRESHOLD) {
            result = THRESHOLD;
        }
        return result;
    }

    public float getAverageLevel(int binNum) {
        return this.avgLevels[binNum].getAverage();
    }

    public void raiseBy(int binNum, float amount) {
        this.avgLevels[binNum].raiseBy(amount);
        this.minAvgBuffers[binNum].raiseBy(-amount);
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public int getLength() {
        return this.length;
    }
}

