/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.LockedMultiScaleFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public class MultiScaleFourierEngine
implements IFourierEngine {
    private static final String DELAYER_SERIAL_SECTION_NAME = String.valueOf(LockedMultiScaleFourierEngine.class.getName()) + " delayer";
    private FourierSpec specs;
    private float[][] mChan;
    private Fork fork;
    private int chunkSize;
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;
    private ConcurrentDelayBuffer orgDelayer;
    private ISerialSection orgDelayerSection;
    private PyramidAnalyzer orgAnalyzer;
    private float[] delayed;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void startProcessing(IProcessingInfo info) {
        this.chunkSize = (int)((float)this.specs.getBaseResolution() / this.specs.getOverlap() + 0.5f);
        this.fork = new Fork(1, this.specs.getSharpInfo(), this.chunkSize, false, this.specs.getNoiseMode(), 1.7f);
        this.analyzer = new PyramidAnalyzer(this.specs.getMultiScaleResolutions(), this.chunkSize, this.specs.getIntOverlap(), this.specs.getAnalysisWindow());
        this.synthesizer = new PyramidSynthesizer(this.specs.getMultiScaleResolutions(), this.chunkSize, this.specs.getIntOverlap(), this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getPostFftProcessor(), this.specs.getSynthesisShrink(), this.specs.getEnergyCorrection(), this.specs.getTimeScale());
        this.synthesizer.setFourierLatency(this.specs.getFourierLatency());
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgAnalyzer = new PyramidAnalyzer("source", this.specs.getOrgResolutions(), this.chunkSize, this.specs.getIntOverlap(), this.specs.getAnalysisWindow());
        }
    }

    private void setupSrcDelayer(IMtContext mtContext) {
        int delayAmount = this.fork.getLatency();
        int inputSize = this.fork.getInputSize();
        this.orgDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + inputSize * mtContext.getSerialRunningMaxSkew(), inputSize);
    }

    public int getFixedChunkLength() {
        return this.chunkSize;
    }

    public int getLatency() {
        int result = (int)((float)this.fork.getLatency() * this.specs.getTimeScale() + 0.5f) + this.synthesizer.getLatency();
        return result += (int)((float)this.synthesizer.getBaseBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
    }

    public int getNbScales() {
        return this.specs.getNbLayers();
    }

    public int getNbResolutions() {
        return this.specs.getNbLayers();
    }

    public int getNbBins() {
        return -1;
    }

    public int getNbBins(int layer) {
        return AudioMath.getCeilingPowerOf2((int)this.specs.getMultiScaleResolutions()[layer]) / 2 + 1;
    }

    public int getEffectiveResolution(int layer) {
        return (int)(this.specs.getSharpInfo().layerInfo[layer].getAnalysisResolution() + 0.5f);
    }

    public int getNumHops(int scale) {
        return this.analyzer.getNumHops(scale);
    }

    public int getInputHopSize() {
        return this.specs.getSharpInfo().hopSize;
    }

    public int getDistanceBetweenFrames(int res) {
        return this.analyzer.getBlockSize(res) / this.analyzer.getOverlap();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.mChan = new float[1][];
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.delayed = new float[this.chunkSize];
        }
        this.fork.init();
        this.analyzer.init();
        this.synthesizer.init();
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgAnalyzer.init();
        }
    }

    public float[] process(float[] data, ISpectrumProcessor processor) {
        this.mChan[0] = data;
        int nbLayers = this.specs.getNbLayers();
        this.fork.process(this.mChan);
        float[][] layers = this.fork.getOutputs(0);
        int i = 0;
        while (i < nbLayers / 2) {
            float[] temp = layers[i];
            layers[i] = layers[nbLayers - i - 1];
            layers[nbLayers - i - 1] = temp;
            ++i;
        }
        Cmplx[][][] orgSpectrums = null;
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            long delayerClock = this.orgDelayerSection.getClock();
            this.orgDelayer.push(data, delayerClock);
            this.orgDelayerSection.sync();
            this.orgDelayer.pop(this.delayed, delayerClock);
            orgSpectrums = this.orgAnalyzer.analyzeInEachRes(this.delayed);
        }
        long clock = this.analyzer.getClock();
        Cmplx[][][] spectrums = this.analyzer.analyze(layers);
        if (this.specs.getAntiLeakage()) {
            int r = 0;
            while (r < nbLayers - 1) {
                int k = 0;
                while (k < spectrums[r].length) {
                    Cmplx[] orgSpectrum = orgSpectrums[r][k];
                    Cmplx[] spectrum = spectrums[r][k];
                    int i2 = 0;
                    while (i2 < spectrum.length) {
                        float sigMag = spectrum[i2].magApprox();
                        float orgMag = orgSpectrum[i2].magApprox();
                        if (orgMag < sigMag) {
                            spectrum[i2].mul(orgMag / sigMag);
                        }
                        ++i2;
                    }
                    ++k;
                }
                ++r;
            }
        }
        int step = 0;
        while (step < processor.getNumSteps()) {
            int r = 0;
            while (r < spectrums.length) {
                Cmplx[][] frames = spectrums[r];
                Cmplx[][] orgFrames = this.specs.getRequiresSource() ? orgSpectrums[r] : spectrums[r];
                int numHops = this.analyzer.getNumHops(r);
                assert (frames.length == numHops && orgFrames.length == numHops);
                int k = 0;
                while (k < frames.length) {
                    processor.process(r, r, orgFrames[k], frames[k], k, clock * (long)numHops + (long)k, step);
                    ++k;
                }
                ++r;
            }
            processor.afterStep(step, clock);
            ++step;
        }
        this.synthesizer.synthesize(spectrums, data);
        return data;
    }

    public void stopProcessing() {
        this.mChan = null;
        this.fork = null;
        this.analyzer = null;
        this.orgAnalyzer = null;
        this.delayed = null;
        this.synthesizer = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.fork.createSerialSections(factory);
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.setupSrcDelayer(factory.getMtContext());
            this.orgDelayerSection = factory.createSerialSection(DELAYER_SERIAL_SECTION_NAME, (Object)this.orgDelayer);
            this.orgAnalyzer.createSerialSections(factory);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.fork.setSerialSections(pool);
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgDelayerSection = pool.getSerialSection(DELAYER_SERIAL_SECTION_NAME);
            this.orgDelayer = (ConcurrentDelayBuffer)this.orgDelayerSection.getUserData();
            this.orgAnalyzer.setSerialSections(pool);
        }
    }
}

