/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public class Spoon
implements IHasSerialSections {
    private final StftAnalyzerMulti analyzer;
    private transient int baseIndex;

    public Spoon(SharpInfo info, int layer) {
        this("spoon" + layer, info.blockSize, info.hopSize, info.layerInfo[layer].analysisShrink, info.layerInfo[layer].enableEnergyCorrection);
    }

    public Spoon(String name, SharpInfo info, int layer) {
        this(String.valueOf(name) + layer, info.blockSize, info.hopSize, info.layerInfo[layer].analysisShrink, info.layerInfo[layer].enableEnergyCorrection);
    }

    public Spoon(String name, int blockSize, int hopSize, float analysisShrink, boolean energyCorrection) {
        float[] analysisWindow = WindowsFactory.getHannWindow(blockSize, analysisShrink, energyCorrection);
        this.analyzer = new StftAnalyzerMulti(blockSize, hopSize, 1, analysisWindow, true);
        this.analyzer.setName(name);
    }

    public void init() {
        this.analyzer.init();
    }

    public Cmplx[] process(float[] input) {
        return this.analyzer.analyze(input)[0];
    }

    public void preProcess(float[] input, long clock) {
        this.baseIndex = this.analyzer.pushInput(input, clock);
    }

    public Cmplx[] postProcess() {
        return this.analyzer.analyzePushedInput(this.baseIndex)[0];
    }

    public int getBlockSize() {
        return this.analyzer.getBlockSize();
    }

    public int getHopSize() {
        return this.analyzer.getHopSize();
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
    }
}

