/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.MinAvgSpectrumBuffer;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import java.util.BitSet;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.InOut;
import org.corebounce.common.utils.Out;

public class TransientExtractor
implements IHasSerialSections {
    private static final float CEIL_LEVEL = 10.0f;
    private static final float FLOOR_LEVEL = (float)AudioMath.dbToLevel((double)-120.0);
    private static final float MAX_SKEW = (float)AudioMath.dbToLevel((double)20.0);
    private final float WEAK_RATIO = (float)AudioMath.dbToLevel((double)-5.0);
    private static final String SECTION_NAME_ENGINE = String.valueOf(TransientExtractor.class.getName()) + ".engine";
    private static final String SECTION_NAME_ATTACK = String.valueOf(TransientExtractor.class.getName()) + ".attack";
    private final String name;
    private final int nbChans;
    private final int nbEngines;
    private final int minimizerLength;
    private final int averagerLength;
    private final int nbBins;
    private final int numHops;
    private final float sensitivity;
    private final double attackSpeed;
    private final int minSpan;
    private final int spread;
    private final boolean hard;
    private final float maxJump;
    private final int minMaskingTime;
    private final int maxMaskingTime;
    private final float floorLevel;
    private final float[][][] inpLevels;
    private final float[][][] levels;
    private final float[][] commonLevels;
    private final Cmplx[][] source;
    private final BitSet[] attacks;
    private final BitSet[] weakAttacks;
    private final float[][][] edgeRatio;
    private final float[][][] startLevels;
    private final float[][][] minAvg;
    private final float[][] currentAttackLevels;
    private MinAvgSpectrumBuffer[] engines;
    private AttackState attackState;
    private ISerialSection engineSection = new DummySerialSection();
    private ISerialSection attackSection = new DummySerialSection();

    public TransientExtractor(String name, int numHops, int nbChans, int nbBins, int minimizerLength, int averagerLength, double sensitivity, double attackSpeed, int minSpan, int spread, boolean hard, boolean splitMode, float maxJump, float hopDuration, boolean masking) {
        this.name = name;
        this.nbChans = nbChans;
        this.nbBins = nbBins;
        this.numHops = numHops;
        this.sensitivity = (float)AudioMath.dbToLevel((double)sensitivity);
        this.attackSpeed = AudioMath.dbToLevel((double)attackSpeed);
        this.minSpan = minSpan;
        this.spread = spread;
        this.hard = hard;
        this.maxJump = maxJump;
        this.floorLevel = (float)AudioMath.dbToLevel((double)-100.0) * (float)sensitivity;
        if (splitMode) {
            this.inpLevels = new float[numHops][nbChans][nbBins];
            this.levels = new float[numHops][nbChans][nbBins];
            this.source = null;
        } else {
            this.inpLevels = null;
            this.levels = null;
            this.source = Cmplx.newArray((int)numHops, (int)nbBins);
        }
        this.commonLevels = new float[numHops][nbBins];
        this.nbEngines = splitMode ? nbChans : 1;
        this.minimizerLength = minimizerLength;
        this.averagerLength = averagerLength;
        this.minAvg = new float[numHops][this.nbEngines][nbBins];
        this.attacks = new BitSet[numHops];
        this.weakAttacks = new BitSet[numHops];
        int k = 0;
        while (k < numHops) {
            this.attacks[k] = new BitSet(nbBins);
            this.weakAttacks[k] = new BitSet(nbBins);
            ++k;
        }
        this.edgeRatio = new float[numHops][nbChans][nbBins];
        this.startLevels = new float[numHops][this.nbEngines][nbBins];
        k = 0;
        while (k < numHops) {
            int c = 0;
            while (c < this.nbEngines) {
                Arrays.fill(this.startLevels[k][c], (float)AudioMath.dbToLevel((double)-100.0));
                ++c;
            }
            ++k;
        }
        this.currentAttackLevels = new float[numHops][nbBins];
        this.minMaskingTime = (int)(0.004f / hopDuration);
        this.maxMaskingTime = !masking ? 0 : (int)(0.02f / hopDuration);
    }

    public int getNbChans() {
        return this.nbChans;
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public void analyzeMixed(Cmplx[][][] channels) {
        if (channels.length != this.numHops) {
            throw new IllegalArgumentException("Illegal number of hops");
        }
        if (channels[0].length != this.nbChans) {
            throw new IllegalArgumentException("Illegal number of channels");
        }
        int k = 0;
        while (k < this.numHops) {
            this.attacks[k].clear();
            this.weakAttacks[k].clear();
            this.fillSum(channels[k], this.source[k]);
            this.computeLevels(this.source[k], this.commonLevels[k]);
            ++k;
        }
        this.engineSection.enterSerialSection();
        k = 0;
        while (k < this.numHops) {
            this.analyzeAttacks(this.engines[0], this.minAvg[k][0], this.commonLevels[k], this.commonLevels[k], this.attacks[k], this.weakAttacks[k]);
            ++k;
        }
        this.engineSection.leaveSerialSection();
        k = 0;
        while (k < this.numHops) {
            this.applyMinSpan(this.attacks[k]);
            this.applySpread(this.attacks[k]);
            this.applyMinSpan(this.weakAttacks[k]);
            this.applySpread(this.weakAttacks[k]);
            this.fillStartLevels(this.startLevels[k][0], this.minAvg[k][0], this.hard, this.attacks[k]);
            ++k;
        }
        this.attackSection.enterSerialSection();
        k = 0;
        while (k < this.numHops) {
            this.updateAttacks(this.attackSpeed, this.attackState.attackLevels, this.attackState.maskingTimes);
            this.processAttacksMixed(this.attacks[k], this.weakAttacks[k], this.startLevels[k], this.attackState.attackLevels, this.attackState.maskingTimes);
            this.copyAttacks(this.attackState.attackLevels, this.currentAttackLevels[k]);
            ++k;
        }
        this.attackSection.leaveSerialSection();
    }

    public void analyseSplitted(Cmplx[][][] source, Cmplx[][][] input) {
        int c;
        if (source.length != this.numHops) {
            throw new IllegalArgumentException("Illegal number of hops");
        }
        if (source[0].length != this.nbChans) {
            throw new IllegalArgumentException("Illegal number of channels");
        }
        int k = 0;
        while (k < this.numHops) {
            this.attacks[k].clear();
            this.weakAttacks[k].clear();
            c = 0;
            while (c < this.nbChans) {
                if (source[k][c].length != this.nbBins) {
                    throw new IllegalArgumentException("Illegal number of bins for channel " + c);
                }
                this.computeLevels(source[k][c], this.levels[k][c]);
                this.computeLevels(input[k][c], this.inpLevels[k][c]);
                ++c;
            }
            ++k;
        }
        this.engineSection.enterSerialSection();
        k = 0;
        while (k < this.numHops) {
            c = 0;
            while (c < this.nbChans) {
                this.analyzeAttacks(this.engines[c], this.minAvg[k][c], this.levels[k][c], this.inpLevels[k][c], this.attacks[k], this.weakAttacks[k]);
                ++c;
            }
            ++k;
        }
        this.engineSection.leaveSerialSection();
        k = 0;
        while (k < this.numHops) {
            this.computeCommonlevels(this.levels[k], this.commonLevels[k]);
            this.applyMinSpan(this.attacks[k]);
            this.applySpread(this.attacks[k]);
            this.applyMinSpan(this.weakAttacks[k]);
            this.applySpread(this.weakAttacks[k]);
            c = 0;
            while (c < this.nbChans) {
                this.fillStartLevels(this.startLevels[k][c], this.minAvg[k][c], this.hard, this.attacks[k]);
                ++c;
            }
            ++k;
        }
        this.attackSection.enterSerialSection();
        k = 0;
        while (k < this.numHops) {
            this.updateAttacks(this.attackSpeed, this.attackState.attackLevels, this.attackState.maskingTimes);
            this.processAttacksSplitted(this.attacks[k], this.weakAttacks[k], this.startLevels[k], this.levels[k], this.commonLevels[k], this.attackState.attackLevels, this.attackState.maskingTimes);
            this.copyAttacks(this.attackState.attackLevels, this.currentAttackLevels[k]);
            ++k;
        }
        this.attackSection.leaveSerialSection();
    }

    public void analyseMonitored(Cmplx[][][] channels, Cmplx[][][] monitor) {
        int c;
        if (channels.length != this.numHops) {
            throw new IllegalArgumentException("Illegal number of hops");
        }
        if (channels[0].length != this.nbChans) {
            throw new IllegalArgumentException("Illegal number of channels");
        }
        int k = 0;
        while (k < this.numHops) {
            this.attacks[k].clear();
            this.weakAttacks[k].clear();
            c = 0;
            while (c < this.nbChans) {
                if (channels[k][c].length != this.nbBins) {
                    throw new IllegalArgumentException("Illegal number of bins for channel " + c);
                }
                this.computeLevels(monitor[k][c], this.commonLevels[k]);
                this.computeLevels(channels[k][c], this.levels[k][c]);
                ++c;
            }
            ++k;
        }
        this.engineSection.enterSerialSection();
        k = 0;
        while (k < this.numHops) {
            c = 0;
            while (c < this.nbChans) {
                this.analyzeAttacksMonitored(this.engines[c], this.minAvg[k][c], this.levels[k][c], this.commonLevels[k], this.attacks[k], this.weakAttacks[k]);
                ++c;
            }
            ++k;
        }
        this.engineSection.leaveSerialSection();
        k = 0;
        while (k < this.numHops) {
            this.computeCommonlevels(this.levels[k], this.commonLevels[k]);
            this.applyMinSpan(this.attacks[k]);
            this.applySpread(this.attacks[k]);
            this.applyMinSpan(this.weakAttacks[k]);
            this.applySpread(this.weakAttacks[k]);
            c = 0;
            while (c < this.nbChans) {
                this.fillStartLevels(this.startLevels[k][c], this.minAvg[k][c], this.hard, this.attacks[k]);
                ++c;
            }
            ++k;
        }
        this.attackSection.enterSerialSection();
        k = 0;
        while (k < this.numHops) {
            this.updateAttacks(this.attackSpeed, this.attackState.attackLevels, this.attackState.maskingTimes);
            this.processAttacksSplitted(this.attacks[k], this.weakAttacks[k], this.startLevels[k], this.levels[k], this.commonLevels[k], this.attackState.attackLevels, this.attackState.maskingTimes);
            this.copyAttacks(this.attackState.attackLevels, this.currentAttackLevels[k]);
            ++k;
        }
        this.attackSection.leaveSerialSection();
    }

    public void processSplitted(Cmplx[][][] input, int chan, Cmplx[][] shortx, Cmplx[][] longx) {
        int k = 0;
        while (k < this.numHops) {
            this.split(input[k][chan], this.levels[k][chan], this.commonLevels[k], this.currentAttackLevels[k], this.edgeRatio[k][chan]);
            this.extract(input[k][chan], this.edgeRatio[k][chan], shortx[k], longx[k]);
            ++k;
        }
    }

    public void processMixed(Cmplx[][][] input, int chan, Cmplx[][] shortx, Cmplx[][] longx) {
        int k = 0;
        while (k < this.numHops) {
            this.split(input[k][chan], this.levels[k][chan], this.commonLevels[k], this.currentAttackLevels[k], this.edgeRatio[k][chan]);
            this.extract(input[k][chan], this.edgeRatio[k][chan], shortx[k], longx[k]);
            ++k;
        }
    }

    private void computeLevels(Cmplx[] input, @Out float[] levels) {
        int i = 0;
        while (i < this.nbBins) {
            levels[i] = input[i].magApprox();
            ++i;
        }
    }

    private void fillSum(Cmplx[][] input, Cmplx[] source) {
        Cmplx[] data0 = input[0];
        int i = 0;
        while (i < this.nbBins) {
            source[i].set(data0[i]);
            ++i;
        }
        int chan = 1;
        while (chan < input.length) {
            Cmplx[] datac = input[chan];
            int i2 = 0;
            while (i2 < this.nbBins) {
                source[i2].add(datac[i2]);
                ++i2;
            }
            ++chan;
        }
    }

    private void analyzeAttacks(@InOut MinAvgSpectrumBuffer engine, @Out float[] minAvg, float[] analyzeLevels, float[] pushLevels, @Out BitSet attacks, @Out BitSet weakAttacks) {
        int i = 0;
        while (i < this.nbBins) {
            float threshold = this.computeThreshold(engine, minAvg, analyzeLevels[i], i);
            if (analyzeLevels[i] > threshold) {
                attacks.set(i);
                weakAttacks.set(i);
            } else if (analyzeLevels[i] > threshold * this.WEAK_RATIO) {
                weakAttacks.set(i);
            }
            ++i;
        }
        engine.push(pushLevels);
    }

    private void analyzeAttacksMonitored(@InOut MinAvgSpectrumBuffer engine, @Out float[] minAvg, float[] levels, float[] monitorLevels, @Out BitSet attacks, @Out BitSet weakAttacks) {
        int i = 0;
        while (i < this.nbBins) {
            float threshold = this.computeThreshold(engine, minAvg, levels[i], i);
            float level = levels[i];
            if (level * MAX_SKEW > monitorLevels[i]) {
                if (level > threshold) {
                    attacks.set(i);
                    weakAttacks.set(i);
                } else if (level > threshold * this.WEAK_RATIO) {
                    weakAttacks.set(i);
                }
            }
            ++i;
        }
        engine.push(monitorLevels);
    }

    private float computeThreshold(@InOut MinAvgSpectrumBuffer engine, @Out float[] minAvg, float level, int i) {
        float thresholdPrev;
        float minAvgLevel;
        float f = minAvgLevel = i == 0 ? engine.getMinAvgLevel(0) : minAvg[i];
        if (minAvgLevel * this.maxJump < level) {
            float raise = level - minAvgLevel * this.maxJump;
            engine.raiseBy(i, raise);
        }
        minAvg[i] = engine.getMinAvgLevel(i);
        float threshold = minAvgLevel * this.sensitivity;
        if (i > 0 && (thresholdPrev = minAvg[i - 1] * this.sensitivity) > threshold) {
            threshold = thresholdPrev;
        }
        if (i < this.nbBins - 1) {
            float nextLevel;
            minAvg[i + 1] = nextLevel = engine.getMinAvgLevel(i + 1);
            float thresholdNext = nextLevel * this.sensitivity;
            if (thresholdNext > threshold) {
                threshold = thresholdNext;
            }
        }
        if (threshold < this.floorLevel) {
            threshold = this.floorLevel;
        }
        return threshold;
    }

    private void computeCommonlevels(float[][] levels, @Out float[] commonLevels) {
        float correction = 1.0f / (float)this.nbChans;
        int i = 0;
        while (i < this.nbBins) {
            commonLevels[i] = levels[0][i] * correction;
            ++i;
        }
        int chan = 1;
        while (chan < this.nbChans) {
            int i2 = 0;
            while (i2 < this.nbBins) {
                int n = i2;
                commonLevels[n] = commonLevels[n] + levels[chan][i2] * correction;
                ++i2;
            }
            ++chan;
        }
    }

    private void applyMinSpan(@InOut BitSet attacks) {
        if (this.minSpan > 1) {
            int start = -1;
            int i = 0;
            while (i < this.nbBins) {
                boolean isShort = attacks.get(i);
                if (isShort) {
                    if (start < 0) {
                        start = i;
                    }
                } else if (start >= 0) {
                    int span;
                    int s = start;
                    if (s == 0) {
                        s = -(this.minSpan + 1) / 2;
                    }
                    if ((span = i - s) < this.minSpan) {
                        attacks.clear(start, i);
                    }
                    start = -1;
                }
                ++i;
            }
        }
    }

    private void applySpread(@InOut BitSet attacks) {
        if (this.spread <= 0) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.nbBins) {
            if (attacks.get(i)) {
                count = this.spread;
            } else if (count > 0) {
                attacks.set(i);
                --count;
            }
            ++i;
        }
        i = this.nbBins - 1;
        while (i >= 0) {
            if (attacks.get(i)) {
                count = this.spread;
            } else if (count > 0) {
                attacks.set(i);
                --count;
            }
            --i;
        }
    }

    private void fillStartLevels(@Out float[] startLevels, float[] minAvg, boolean hard, BitSet attacks) {
        Arrays.fill(startLevels, 10.0f);
        if (hard) {
            float sumLevel = 0.0f;
            int startBin = -1;
            int i = 0;
            while (i <= this.nbBins) {
                if (i < this.nbBins && attacks.get(i)) {
                    if (startBin < 0) {
                        startBin = i;
                        sumLevel = 0.0f;
                    }
                    float level = minAvg[i];
                    sumLevel += level;
                } else if (startBin >= 0) {
                    int j = startBin;
                    while (j < i) {
                        startLevels[j] = sumLevel / (float)(i - startBin);
                        ++j;
                    }
                    startBin = -1;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.nbBins) {
                if (attacks.get(i)) {
                    startLevels[i] = minAvg[i];
                }
                ++i;
            }
        }
    }

    private void updateAttacks(double attackSpeed, @InOut float[] commonAttackLevels, @InOut int[] maskingTimes) {
        int i = 0;
        while (i < this.nbBins) {
            int n = i;
            commonAttackLevels[n] = (float)((double)commonAttackLevels[n] * attackSpeed);
            if (commonAttackLevels[i] > 10.0f) {
                commonAttackLevels[i] = 10.0f;
            }
            int n2 = i++;
            maskingTimes[n2] = maskingTimes[n2] + 1;
        }
    }

    private void processAttacksMixed(BitSet attacks, BitSet weakAttacks, float[][] startLevels, @InOut float[] commonAttackLevels, @InOut int[] maskingTimes) {
        int i = 0;
        while (i < this.nbBins) {
            float newLevel;
            boolean masked;
            int maskingTime = maskingTimes[i];
            boolean bl = masked = maskingTime > this.minMaskingTime && maskingTime < this.maxMaskingTime;
            if (attacks.get(i) && !masked && (newLevel = startLevels[0][i]) < commonAttackLevels[i]) {
                commonAttackLevels[i] = newLevel;
            }
            if (attacks.get(i) && !masked || weakAttacks.get(i) && masked) {
                maskingTimes[i] = this.minMaskingTime;
            }
            ++i;
        }
    }

    private void processAttacksSplitted(BitSet attacks, BitSet weakAttacks, float[][] startLevels, float[][] levels, float[] commonLevels, @InOut float[] commonAttackLevels, @InOut int[] maskingTimes) {
        int i = 0;
        while (i < this.nbBins) {
            boolean masked;
            int maskingTime = maskingTimes[i];
            boolean bl = masked = maskingTime > this.minMaskingTime && maskingTime < this.maxMaskingTime;
            if (attacks.get(i) && !masked) {
                float minRatio = 1.0f;
                int chan = 0;
                while (chan < this.nbChans) {
                    float ratio;
                    float startLevel = startLevels[chan][i];
                    if (levels[chan][i] > FLOOR_LEVEL && (ratio = startLevel / levels[chan][i]) < minRatio) {
                        minRatio = ratio;
                    }
                    ++chan;
                }
                float newLevel = commonLevels[i] * minRatio;
                if (newLevel < commonAttackLevels[i]) {
                    commonAttackLevels[i] = newLevel;
                }
            }
            if (attacks.get(i) && !masked || weakAttacks.get(i) && masked) {
                maskingTimes[i] = this.minMaskingTime;
            }
            ++i;
        }
    }

    private void copyAttacks(float[] commonAttackLevels, @Out float[] currentAttackLevels) {
        System.arraycopy(commonAttackLevels, 0, currentAttackLevels, 0, this.nbBins);
    }

    private void split(Cmplx[] input, float[] levels, float[] commonLevels, float[] currentAttackLevels, @Out float[] edgeRatio) {
        int i = 0;
        while (i < this.nbBins) {
            if (commonLevels[i] > FLOOR_LEVEL) {
                float ratio = currentAttackLevels[i] / commonLevels[i];
                float attackLevel = levels[i] * ratio;
                float level = input[i].magApprox();
                if (level > attackLevel) {
                    float cropped = attackLevel;
                    edgeRatio[i] = (level - cropped) / level;
                } else {
                    edgeRatio[i] = 0.0f;
                }
            } else {
                edgeRatio[i] = 0.0f;
            }
            ++i;
        }
    }

    private void extract(Cmplx[] input, float[] edgeRatio, Cmplx[] shortx, Cmplx[] longx) {
        int i = 0;
        while (i < this.nbBins) {
            float edge = edgeRatio[i];
            float rest = 1.0f - edge;
            Cmplx data = input[i];
            shortx[i].set(data.re * edge, data.im * edge);
            longx[i].set(data.re * rest, data.im * rest);
            ++i;
        }
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engines = new MinAvgSpectrumBuffer[this.nbEngines];
        int i = 0;
        while (i < this.nbEngines) {
            this.engines[i] = new MinAvgSpectrumBuffer(this.nbBins, this.minimizerLength, this.averagerLength);
            ++i;
        }
        this.attackState = new AttackState();
        this.attackState.attackLevels = new float[this.nbBins];
        this.attackState.maskingTimes = new int[this.nbBins];
        Arrays.fill(this.attackState.attackLevels, (float)AudioMath.dbToLevel((double)-100.0));
        this.engineSection = factory.createSerialSection(String.valueOf(SECTION_NAME_ENGINE) + "." + this.name, (Object)this.engines);
        this.attackSection = factory.createSerialSection(String.valueOf(SECTION_NAME_ATTACK) + "." + this.name, (Object)this.attackState);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engineSection = pool.getSerialSection(String.valueOf(SECTION_NAME_ENGINE) + "." + this.name);
        this.attackSection = pool.getSerialSection(String.valueOf(SECTION_NAME_ATTACK) + "." + this.name);
        this.engines = (MinAvgSpectrumBuffer[])this.engineSection.getUserData();
        this.attackState = (AttackState)this.attackSection.getUserData();
    }

    static class AttackState {
        public float[] attackLevels;
        public int[] maskingTimes;

        AttackState() {
        }
    }
}

