/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.adaptive.Dish;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public abstract class AdaptivePushEffectBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private static final String ORG_DELAYER_SERIAL_SECTION_NAME = String.valueOf(AdaptivePushEffectBase.class.getName()) + " delayer";
    private static final int NB_LAYERS = 2;
    private static final int[][] RESOLUTIONS = new int[][]{{2048, 2048, 1024, 1024, 1024}, {16384, 8192, 4096, 2048, 1024}};
    private static final int NB_SCALES = 5;
    private static final int[] SCALES = new int[]{16384, 8192, 4096, 2048, 1024};
    private static final int[] ORG_SCALES = new int[]{16384, 8192, 4096, 2048};
    private static final float[] SPLIT_FREQS = new float[]{1250.0f, 3700.0f, 6400.0f, 10000.0f};
    private static final int MAX_RES = RESOLUTIONS[RESOLUTIONS.length - 1][0];
    private static final int MIN_RES = RESOLUTIONS[0][RESOLUTIONS[0].length - 1];
    private static final int OUT_MUL = 2;
    private float[][] mChan;
    private Fork fork;
    private Dish dish;
    private int chunkSize;
    private int overlap = 8;
    private float[] analysisWindow;
    private float[] synthesisWindow;
    private boolean rotate;
    private float shrinkEnergyCorrection = 4.0f;
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;
    private float[] output;
    private ConcurrentDelayBuffer orgDelayer;
    private ISerialSection orgDelayerSection;
    private PyramidAnalyzer orgAnalyzer;
    private float[] delayed;

    protected final int getBaseResolution() {
        return AudioMath.getCeilingPowerOf2((int)SCALES[0]);
    }

    protected int getOverlap() {
        return this.overlap;
    }

    protected void setOverlap(int overlap) {
        this.overlap = overlap;
    }

    protected float[] getAnalysisWindow() {
        return this.analysisWindow;
    }

    protected void setAnalysisWindow(float[] analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    protected float[] getSynthesisWindow() {
        return this.synthesisWindow;
    }

    protected void setSynthesisWindow(float[] synthesisWindow) {
        this.synthesisWindow = synthesisWindow;
    }

    protected boolean isRotate() {
        return this.rotate;
    }

    protected void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    protected float getShrinkEnergyCorrection() {
        return this.shrinkEnergyCorrection;
    }

    protected void setShrinkEnergyCorrection(float shrinkEnergyCorrection) {
        this.shrinkEnergyCorrection = shrinkEnergyCorrection;
    }

    public void startProcessing(IProcessingInfo info) {
        this.chunkSize = AudioMath.getCeilingPowerOf2((int)SCALES[0]) / this.overlap;
        SharpInfo sharpInfoSplit = new SharpInfo(MAX_RES, 2, MAX_RES / MIN_RES, MAX_RES, 16.0f, true, 2.0f, info.getSampleRate());
        this.fork = new Fork(1, sharpInfoSplit, this.chunkSize, false, false, 1.7f);
        this.dish = new Dish(RESOLUTIONS, SPLIT_FREQS, this.fork.getInputSize(), 512, info.getSampleRate());
        this.analyzer = new PyramidAnalyzer(SCALES, this.chunkSize, this.overlap, this.analysisWindow);
        this.synthesizer = new PyramidSynthesizer(SCALES, this.chunkSize * 2, this.overlap / 2, this.analysisWindow, this.synthesisWindow, null, this.shrinkEnergyCorrection, true, this.rotate ? 2.0f : 1.0f);
        this.orgAnalyzer = new PyramidAnalyzer("source", ORG_SCALES, this.chunkSize, this.overlap, this.analysisWindow);
    }

    private void setupSrcDelayer(IMtContext mtContext) {
        int delayAmount = this.fork.getLatency() + this.dish.getLatency();
        int inputSize = this.fork.getInputSize();
        this.orgDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + inputSize * mtContext.getSerialRunningMaxSkew(), inputSize);
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public int getLatency(IoDirection ioDirection) {
        return this.fork.getLatency() + this.dish.getLatency() + this.synthesizer.getLatency();
    }

    public int getFixedChunkLength() {
        return this.chunkSize;
    }

    protected int getNbBins() {
        return -1;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.mChan = new float[1][];
        this.delayed = new float[this.chunkSize];
        this.output = new float[this.chunkSize * 2];
        this.fork.init();
        this.dish.init();
        this.analyzer.init();
        this.synthesizer.init();
        this.orgAnalyzer.init();
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        this.mChan[0] = input;
        this.fork.process(this.mChan);
        float[][] layers = this.fork.getOutputs(0);
        float[][] scales = this.dish.process(layers);
        int i = 0;
        while (i < 2) {
            float[] temp = scales[i];
            scales[i] = scales[5 - i - 1];
            scales[5 - i - 1] = temp;
            ++i;
        }
        long delayerClock = this.orgDelayerSection.getClock();
        this.orgDelayer.push(input, delayerClock);
        this.orgDelayerSection.sync();
        this.orgDelayer.pop(this.delayed, delayerClock);
        Cmplx[][][] orgSpectrums = this.orgAnalyzer.analyzeInEachRes(this.delayed);
        Cmplx[][][] spectrums = this.analyzer.analyze(scales);
        int r = 0;
        while (r < ORG_SCALES.length) {
            int k = 0;
            while (k < spectrums[r].length) {
                Cmplx[] orgSpectrum = orgSpectrums[r][k];
                Cmplx[] spectrum = spectrums[r][k];
                int i2 = 0;
                while (i2 < spectrum.length) {
                    float sigMag = spectrum[i2].magApprox();
                    float orgMag = orgSpectrum[i2].magApprox();
                    if (orgMag < sigMag) {
                        spectrum[i2].mul(orgMag / sigMag);
                    }
                    ++i2;
                }
                ++k;
            }
            ++r;
        }
        r = 0;
        while (r < spectrums.length) {
            Cmplx[][] frames = spectrums[r];
            int k = 0;
            while (k < frames.length) {
                this.processSpectrum(frames[k]);
                ++k;
            }
            ++r;
        }
        this.synthesizer.synthesize(spectrums, this.output);
        if (length == input.length) {
            target.writeSamples(this.output);
        } else {
            float[] lastOutput = new float[length * this.output.length / input.length];
            System.arraycopy(this.output, 0, lastOutput, 0, lastOutput.length);
            target.writeSamples(lastOutput);
        }
    }

    protected abstract void processSpectrum(Cmplx[] var1);

    public void stopProcessing() {
        this.mChan = null;
        this.fork = null;
        this.analyzer = null;
        this.orgAnalyzer = null;
        this.orgDelayer = null;
        this.delayed = null;
        this.synthesizer = null;
        this.output = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.fork.createSerialSections(factory);
        this.dish.createSerialSections(factory);
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
        this.setupSrcDelayer(factory.getMtContext());
        this.orgDelayerSection = factory.createSerialSection(ORG_DELAYER_SERIAL_SECTION_NAME, (Object)this.orgDelayer);
        this.orgAnalyzer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.fork.setSerialSections(pool);
        this.dish.setSerialSections(pool);
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
        this.orgDelayerSection = pool.getSerialSection(ORG_DELAYER_SERIAL_SECTION_NAME);
        this.orgDelayer = (ConcurrentDelayBuffer)this.orgDelayerSection.getUserData();
        this.orgAnalyzer.setSerialSections(pool);
    }
}

