/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.base.stft.StftAnalyzerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public class KheopsAnalyzer
implements IHasSerialSections {
    private static final String SECTION_NAME = "ch.tachyon.sonics.kheops.analyzer";
    private final int nbResolutions;
    private final int baseResolution;
    private final int maxOverlap;
    private final int inputSize;
    private final StftAnalyzerMulti[] analyzers;
    private ISerialSection ss = new DummySerialSection();

    public KheopsAnalyzer(int[] resolutions, int inputSize, int maxOverlap, float[] analysisWindow) {
        this.nbResolutions = resolutions.length;
        this.baseResolution = resolutions[0];
        this.maxOverlap = maxOverlap;
        this.inputSize = inputSize;
        this.analyzers = new StftAnalyzerMulti[this.nbResolutions];
        int hopSize = this.baseResolution / maxOverlap;
        if (inputSize % hopSize != 0) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.nbResolutions) {
            if (this.baseResolution % resolutions[i] != 0) {
                throw new IllegalArgumentException("Each resolution must be a power of 2 fraction of the preceding one");
            }
            if (analysisWindow == null) {
                analysisWindow = WindowsFactory.getHannWindow(this.baseResolution);
            }
            if (resolutions[i] % hopSize != 0 || resolutions[i] <= hopSize) {
                throw new IllegalArgumentException("maxOverlap must be sufficiently high to accomodate the lowest resolution");
            }
            this.analyzers[i] = new StftAnalyzerMulti(this.baseResolution, hopSize, inputSize / hopSize, KheopsAnalyzer.shrinkTo(analysisWindow, resolutions[i]), true);
            this.analyzers[i].setName(String.valueOf(resolutions[i]));
            ++i;
        }
    }

    private static float[] shrinkTo(float[] window, int size) {
        float[] result = new float[window.length];
        int offset = (window.length - size) / 2;
        int i = 0;
        while (i < size) {
            result[i + offset] = window[i * window.length / size];
            ++i;
        }
        return result;
    }

    public void init() {
        StftAnalyzerMulti[] stftAnalyzerMultiArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzerMulti analyzer = stftAnalyzerMultiArray[n2];
            analyzer.init();
            ++n2;
        }
    }

    public int getMaxOverlap() {
        return this.maxOverlap;
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public Cmplx[][][] analyze(float[] input) {
        if (input.length != this.inputSize) {
            throw new IllegalArgumentException("The length of the input (" + input.length + ") does not match the expected length " + this.inputSize);
        }
        Cmplx[][][] results = new Cmplx[this.nbResolutions][][];
        int[] baseIndexes = new int[this.nbResolutions];
        int i = 0;
        while (i < this.nbResolutions) {
            baseIndexes[i] = this.analyzers[i].pushInput(input, this.ss.getClock());
            ++i;
        }
        this.ss.sync();
        i = 0;
        while (i < this.nbResolutions) {
            results[i] = this.analyzers[i].analyzePushedInput(baseIndexes[i]);
            ++i;
        }
        return results;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        StftAnalyzerMulti[] stftAnalyzerMultiArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzerMulti analyzer = stftAnalyzerMultiArray[n2];
            analyzer.createSerialSections(factory);
            ++n2;
        }
        this.ss = factory.createSerialSection(SECTION_NAME, null);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.ss = pool.getSerialSection(SECTION_NAME);
        StftAnalyzerMulti[] stftAnalyzerMultiArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzerMulti analyzer = stftAnalyzerMultiArray[n2];
            analyzer.setSerialSections(pool);
            ++n2;
        }
    }
}

