/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.old.KheopsAnalyzer;
import ch.tachyon.sonics.effect.base.old.KheopsSynthesizer;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public abstract class KheopsPushEffectBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private static final int[] RESOLUTIONS = new int[]{8192, 4096, 2048, 1024};
    private static final float[] SPLIT_FREQS = new float[]{3700.0f, 6400.0f, 10000.0f};
    private static final int OUT_MUL = 2;
    private int overlap = 64;
    private float[] analysisWindow;
    private float[] synthesisWindow;
    private boolean rotate;
    private boolean energyCorrection = true;
    private KheopsAnalyzer analyzer;
    private KheopsSynthesizer synthesizer;
    private float[] output;
    private transient float sampleRate;
    private transient Cmplx[][] source;
    private transient Cmplx[][] frame;

    protected final int getBaseResolution() {
        return RESOLUTIONS[0];
    }

    protected int getOverlap() {
        return this.overlap;
    }

    protected void setOverlap(int overlap) {
        this.overlap = overlap;
    }

    protected float[] getAnalysisWindow() {
        return this.analysisWindow;
    }

    protected void setAnalysisWindow(float[] analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    protected float[] getSynthesisWindow() {
        return this.synthesisWindow;
    }

    protected void setSynthesisWindow(float[] synthesisWindow) {
        this.synthesisWindow = synthesisWindow;
    }

    protected void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    protected void setEnergyCorrection(boolean energyCorrection) {
        this.energyCorrection = energyCorrection;
    }

    public void startProcessing(IProcessingInfo info) {
        int blockSize = RESOLUTIONS[0];
        int hopSize = blockSize / this.overlap;
        int numHops = 1;
        int chunkLength = info.getHostPreferredChunkLength();
        if (chunkLength > 0 && (numHops = chunkLength / hopSize) < 1) {
            numHops = 1;
        }
        int inputSize = hopSize * numHops;
        info.negociateFixedChunkLength(inputSize);
        this.analyzer = new KheopsAnalyzer(RESOLUTIONS, inputSize, this.overlap, this.analysisWindow);
        this.synthesizer = new KheopsSynthesizer(RESOLUTIONS, inputSize * 2, this.overlap / 2, this.analysisWindow, this.synthesisWindow, this.rotate, this.energyCorrection);
        this.output = new float[inputSize * 2];
        this.sampleRate = info.getSampleRate();
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public int getFixedChunkLength() {
        return this.analyzer.getInputSize();
    }

    public int getLatency(IoDirection ioDirection) {
        return this.synthesizer.getLatency();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.analyzer.init();
        this.synthesizer.init();
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        Cmplx[][][] spectrums = this.analyzer.analyze(input);
        this.splitFrequencies(spectrums);
        Cmplx[][] sources = this.fillSumOfResolutions(spectrums);
        int k = 0;
        while (k < spectrums[0].length) {
            Cmplx[][] frame = this.getFrame(k, spectrums);
            this.processSpectrum(sources[k], frame);
            ++k;
        }
        this.synthesizer.synthesize(spectrums, this.output);
        if (length == input.length) {
            target.writeSamples(this.output);
        } else {
            float[] lastOutput = new float[length * this.output.length / input.length];
            System.arraycopy(this.output, 0, lastOutput, 0, lastOutput.length);
            target.writeSamples(lastOutput);
        }
    }

    private void splitFrequencies(Cmplx[][][] spectrums) {
        int r = 0;
        while (r < spectrums.length) {
            float lowFreq = r == 0 ? 0.0f : SPLIT_FREQS[r - 1];
            float hihFreq = r >= SPLIT_FREQS.length ? 24000.0f : SPLIT_FREQS[r];
            float lowR = lowFreq / this.sampleRate;
            float hihR = hihFreq / this.sampleRate;
            int res = RESOLUTIONS[0];
            int lowBin = this.cut2bin(res, lowR, -1);
            int hihBin = this.cut2bin(res, hihR, 1);
            int k = 0;
            while (k < spectrums[r].length) {
                Cmplx[] spectrum = spectrums[r][k];
                int i = 0;
                while (i < spectrum.length) {
                    if (i < lowBin || i > hihBin) {
                        spectrum[i].set(0.0f, 0.0f);
                    }
                    ++i;
                }
                ++k;
            }
            ++r;
        }
    }

    private int cut2bin(int fftSize, float freq, int rounding) {
        int nbBins = fftSize / 2 + 1;
        float offset = (float)(rounding + 1) * 0.4999f;
        int result = (int)(freq * (float)fftSize + offset);
        if (result < 0) {
            result = 0;
        } else if (result >= nbBins) {
            result = nbBins - 1;
        }
        return result;
    }

    private Cmplx[][] fillSumOfResolutions(Cmplx[][][] spectrums) {
        int nbResolutions = spectrums.length;
        int nbFrames = spectrums[0].length;
        int nbBins = spectrums[0][0].length;
        if (this.source == null) {
            this.source = Cmplx.newArray((int)nbFrames, (int)nbBins);
        }
        Cmplx[][] rSpectrums = spectrums[0];
        int k = 0;
        while (k < nbFrames) {
            Cmplx[] rkSpectrum = rSpectrums[k];
            Cmplx[] kSource = this.source[k];
            int i = 0;
            while (i < nbBins) {
                kSource[i].set(rkSpectrum[i]);
                ++i;
            }
            ++k;
        }
        int r = 1;
        while (r < nbResolutions) {
            Cmplx[][] rSpectrums2 = spectrums[r];
            int k2 = 0;
            while (k2 < nbFrames) {
                Cmplx[] rkSpectrum = rSpectrums2[k2];
                Cmplx[] kSource = this.source[k2];
                int i = 0;
                while (i < nbBins) {
                    kSource[i].add(rkSpectrum[i]);
                    ++i;
                }
                ++k2;
            }
            ++r;
        }
        return this.source;
    }

    private Cmplx[][] getFrame(int k, Cmplx[][][] spectrums) {
        int nbResolutions = spectrums.length;
        int nbBins = spectrums[0][0].length;
        if (this.frame == null) {
            this.frame = new Cmplx[nbResolutions][nbBins];
        }
        int r = 0;
        while (r < nbResolutions) {
            this.frame[r] = spectrums[r][k];
            ++r;
        }
        return this.frame;
    }

    protected abstract void processSpectrum(Cmplx[] var1, Cmplx[][] var2);

    protected final int getNbResolutions() {
        return RESOLUTIONS.length;
    }

    protected final int getNbBins() {
        return RESOLUTIONS[0] / 2 + 1;
    }

    public void stopProcessing() {
        this.source = null;
        this.analyzer = null;
        this.synthesizer = null;
        this.output = null;
        this.frame = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
    }
}

