/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.base.stft.StftSynthesizerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public class KheopsSynthesizer
implements IHasSerialSections {
    private static final String SECTION_NAME = "ch.tachyon.sonics.kheops.synthesizer";
    private final int nbResolutions;
    private final int baseResolution;
    private final int[] resolutions;
    private final int outputSize;
    private final int maxOverlap;
    private final boolean rotate;
    private final StftSynthesizerMulti[] synthesizers;
    private final float[][] outputs;
    private ISerialSection ss = new DummySerialSection();

    public KheopsSynthesizer(int[] resolutions, int outputSize, int maxOverlap, float[] analysisWindow, float[] synthesisWindow, final boolean rotate, final boolean energyCorrection) {
        this.resolutions = new int[resolutions.length];
        System.arraycopy(resolutions, 0, this.resolutions, 0, resolutions.length);
        this.nbResolutions = resolutions.length;
        this.baseResolution = resolutions[0];
        this.outputSize = outputSize;
        this.maxOverlap = maxOverlap;
        this.rotate = rotate;
        int hopSize = this.baseResolution / maxOverlap;
        if (outputSize % hopSize != 0) {
            throw new IllegalArgumentException();
        }
        this.synthesizers = new StftSynthesizerMulti[this.nbResolutions];
        int i = 0;
        while (i < this.nbResolutions) {
            if (i > 0 && resolutions[i] >= resolutions[i - 1]) {
                throw new IllegalArgumentException("Resolutions must be decreasing");
            }
            if (analysisWindow == null) {
                analysisWindow = WindowsFactory.getHannWindow(this.baseResolution);
            }
            if (synthesisWindow == null) {
                synthesisWindow = WindowsFactory.getHannWindow(this.baseResolution);
            }
            final int blockSize = resolutions[0];
            final int cellSize = resolutions[i];
            final float analysisShrink = (float)this.baseResolution / (float)resolutions[i];
            this.synthesizers[i] = new StftSynthesizerMulti(this.baseResolution, hopSize, outputSize / hopSize, KheopsSynthesizer.shrinkTo(analysisWindow, resolutions[i]), KheopsSynthesizer.shrinkTo(synthesisWindow, resolutions[i])){

                protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                    super.backwardFFT(spectrum, output);
                    if (rotate) {
                        int middle = output.length / 2;
                        int i = 0;
                        while (i < middle) {
                            float temp = output[i];
                            output[i] = -output[i + middle];
                            output[i + middle] = -temp;
                            ++i;
                        }
                    }
                }

                protected void applySynthesisWindow(float[] output) {
                    if (energyCorrection) {
                        float correction = 1.0f;
                        float maxCorrection = (float)Math.sqrt(analysisShrink);
                        int cellStart = (blockSize - cellSize) / 2;
                        int cellStop = cellStart + cellSize;
                        float cellEnergy = 0.0f;
                        float blockEnergy = 0.0f;
                        int i = 0;
                        while (i < blockSize) {
                            float p = output[i] * output[i];
                            blockEnergy += p;
                            if (i >= cellStart && i < cellStop) {
                                cellEnergy += p;
                            }
                            ++i;
                        }
                        if (cellEnergy > 0.0f && (correction = (float)Math.sqrt(blockEnergy / cellEnergy)) > maxCorrection) {
                            correction = maxCorrection;
                        }
                        super.applySynthesisWindow(output);
                        i = 0;
                        while (i < output.length) {
                            int n = i++;
                            output[n] = output[n] * correction;
                        }
                    } else {
                        super.applySynthesisWindow(output);
                    }
                }
            };
            this.synthesizers[i].setName(String.valueOf(resolutions[i]));
            ++i;
        }
        this.outputs = new float[this.nbResolutions][outputSize];
    }

    private static float[] shrinkTo(float[] window, int size) {
        float[] result = new float[window.length];
        int offset = (window.length - size) / 2;
        int i = 0;
        while (i < size) {
            result[i + offset] = window[i * window.length / size];
            ++i;
        }
        return result;
    }

    public void init() {
        StftSynthesizerMulti[] stftSynthesizerMultiArray = this.synthesizers;
        int n = this.synthesizers.length;
        int n2 = 0;
        while (n2 < n) {
            StftSynthesizerMulti synthesizer = stftSynthesizerMultiArray[n2];
            synthesizer.init();
            ++n2;
        }
    }

    public int getOutputSize() {
        return this.outputSize;
    }

    public int getMaxOverlap() {
        return this.maxOverlap;
    }

    public void synthesize(Cmplx[][][] spectrums, float[] output) {
        if (output.length != this.outputSize) {
            throw new IllegalArgumentException("Given output size (" + output.length + ") does not match expected size " + this.outputSize);
        }
        long clock = this.ss.getClock();
        int i = 0;
        while (i < this.nbResolutions) {
            this.synthesizers[i].preSynthesize(spectrums[i], clock);
            ++i;
        }
        this.ss.sync();
        i = 0;
        while (i < this.nbResolutions) {
            this.synthesizers[i].renderResult(this.outputs[i], clock);
            if (i == 0) {
                System.arraycopy(this.outputs[0], 0, output, 0, output.length);
            } else {
                int j = 0;
                while (j < output.length) {
                    int n = j;
                    output[n] = output[n] + this.outputs[i][j];
                    ++j;
                }
            }
            ++i;
        }
    }

    public int getLatency() {
        int result = this.synthesizers[0].getLatency();
        if (this.rotate) {
            result += this.resolutions[0] / 2;
        }
        return result;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        StftSynthesizerMulti[] stftSynthesizerMultiArray = this.synthesizers;
        int n = this.synthesizers.length;
        int n2 = 0;
        while (n2 < n) {
            StftSynthesizerMulti synthesizer = stftSynthesizerMultiArray[n2];
            synthesizer.createSerialSections(factory);
            ++n2;
        }
        this.ss = factory.createSerialSection(SECTION_NAME, null);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.ss = pool.getSerialSection(SECTION_NAME);
        StftSynthesizerMulti[] stftSynthesizerMultiArray = this.synthesizers;
        int n = this.synthesizers.length;
        int n2 = 0;
        while (n2 < n) {
            StftSynthesizerMulti synthesizer = stftSynthesizerMultiArray[n2];
            synthesizer.setSerialSections(pool);
            ++n2;
        }
    }
}

