/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.adaptive.Cup;
import ch.tachyon.sonics.effect.base.adaptive.Dish;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.adaptive.Spoon;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public abstract class LockedAdaptivePushEffectBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private static final int NB_LAYERS = 2;
    private static final int NB_SCALES = 5;
    private static final int[][] RESOLUTIONS = new int[][]{{2048, 2048, 1024, 1024, 1024}, {16384, 8192, 4096, 2048, 1024}};
    private static final float[] SPLIT_FREQS = new float[]{1250.0f, 3700.0f, 6400.0f, 10000.0f};
    private static final int MAX_RES = RESOLUTIONS[RESOLUTIONS.length - 1][0];
    private static final int MIN_RES = RESOLUTIONS[0][RESOLUTIONS[0].length - 1];
    private static final int OUT_MUL = 2;
    private static final String SPOON_SERIAL_SECTION_NAME = String.valueOf(LockedAdaptivePushEffectBase.class.getName()) + " spoon";
    private static final String CUP_SERIAL_SECTION_NAME = String.valueOf(LockedAdaptivePushEffectBase.class.getName()) + " cup";
    private static final String DELAYER_SERIAL_SECTION_NAME = String.valueOf(LockedAdaptivePushEffectBase.class.getName()) + " delayer";
    private int nbBins;
    private float[][] mChan;
    private Fork fork;
    private Dish dish;
    private Spoon[] spoons;
    private ConcurrentDelayBuffer orgDelayer;
    private Spoon[] orgSpoons;
    private Cup[] cups;
    private Cmplx[][] spectrums;
    private Cmplx[][] orgSpectrums;
    private Cmplx[] sourcePhi;
    private float[] delayed;
    private float[] output;
    private ISerialSection spoonSerialSection;
    private ISerialSection cupSerialSection;
    private ISerialSection delayerSerialSection;

    public void startProcessing(IProcessingInfo info) {
        SharpInfo sharpInfoSplit = new SharpInfo(MAX_RES, 2, MAX_RES / MIN_RES, MAX_RES, 16.0f, true, 2.0f, info.getSampleRate());
        SharpInfo sharpInfoIn = new SharpInfo(MAX_RES, 5, 2.0f, MAX_RES, 16.0f, true, 2.0f, info.getSampleRate());
        SharpInfo sharpInfoOut = sharpInfoIn.halfOverlapCopy(4.0f);
        this.fork = new Fork(1, sharpInfoSplit);
        this.dish = new Dish(RESOLUTIONS, SPLIT_FREQS, this.fork.getInputSize(), 512, info.getSampleRate());
        this.spoons = new Spoon[5];
        this.orgSpoons = new Spoon[5];
        this.cups = new Cup[5];
        int i = 0;
        while (i < 5) {
            this.spoons[i] = new Spoon(sharpInfoIn, i);
            if (i > 0) {
                this.orgSpoons[i] = new Spoon("org", sharpInfoIn, i);
            }
            this.cups[i] = new Cup(sharpInfoOut, i, null);
            ++i;
        }
    }

    private void setupSrcDelayer(IMtContext mtContext) {
        int delayAmount = this.fork.getLatency() + this.dish.getLatency();
        int inputSize = this.fork.getInputSize();
        this.orgDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + inputSize * mtContext.getSerialRunningMaxSkew(), inputSize);
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public int getLatency(IoDirection ioDirection) {
        return this.fork.getLatency() + this.dish.getLatency() + this.cups[0].getLatency();
    }

    public int getFixedChunkLength() {
        return this.fork.getInputSize();
    }

    protected int getNbBins() {
        return this.spoons[0].getBlockSize() / 2 + 1;
    }

    public void beginProcessing(IProcessingInfo info) {
        Spoon spoon;
        this.mChan = new float[1][];
        this.nbBins = MAX_RES / 2 + 1;
        this.spectrums = new Cmplx[5][];
        this.orgSpectrums = new Cmplx[5][];
        this.delayed = new float[this.fork.getInputSize()];
        this.sourcePhi = Cmplx.newArray((int)this.nbBins);
        this.output = new float[this.fork.getInputSize() * 2];
        this.fork.init();
        this.dish.init();
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            spoon.init();
            ++n2;
        }
        objectArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            if (spoon != null) {
                spoon.init();
            }
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).init();
            ++n2;
        }
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        this.mChan[0] = input;
        this.fork.process(this.mChan);
        float[][] layers = this.fork.getOutputs(0);
        float[][] scales = this.dish.process(layers);
        long delayerClock = this.delayerSerialSection.getClock();
        this.orgDelayer.push(input, delayerClock);
        this.delayerSerialSection.sync();
        this.orgDelayer.pop(this.delayed, delayerClock);
        int scale = 0;
        while (scale < 5) {
            this.spoons[scale].preProcess(scales[scale], this.spoonSerialSection.getClock());
            ++scale;
        }
        scale = 1;
        while (scale < 5) {
            this.orgSpoons[scale].preProcess(this.delayed, this.spoonSerialSection.getClock());
            ++scale;
        }
        this.spoonSerialSection.sync();
        scale = 1;
        while (scale < 5) {
            this.orgSpectrums[scale] = this.orgSpoons[scale].postProcess();
            ++scale;
        }
        scale = 0;
        while (scale < 5) {
            this.spectrums[scale] = this.spoons[scale].postProcess();
            ++scale;
        }
        int r = 1;
        while (r < 5) {
            Cmplx[] orgSpectrum = this.orgSpectrums[r];
            Cmplx[] spectrum = this.spectrums[r];
            int i = 0;
            while (i < spectrum.length) {
                float sigMag = spectrum[i].magApprox();
                float srcMag = orgSpectrum[i].magApprox();
                if (srcMag < sigMag) {
                    spectrum[i].mul(srcMag / sigMag);
                }
                ++i;
            }
            ++r;
        }
        this.fillAveragedPhases(this.spectrums);
        this.lockPhases(this.spectrums);
        this.processSpectrum(this.spectrums);
        Arrays.fill(this.output, 0.0f);
        long cupClock = this.cupSerialSection.getClock();
        int scale2 = 0;
        while (scale2 < 5) {
            this.cups[scale2].preProcessAdd(this.spectrums[scale2], cupClock);
            ++scale2;
        }
        this.cupSerialSection.sync();
        scale2 = 0;
        while (scale2 < 5) {
            this.cups[scale2].postProcessAdd(this.output, cupClock);
            ++scale2;
        }
        if (length == input.length) {
            target.writeSamples(this.output);
        } else {
            float[] lastOutput = new float[length * this.output.length / input.length];
            System.arraycopy(this.output, 0, lastOutput, 0, lastOutput.length);
            target.writeSamples(lastOutput);
        }
    }

    private void fillAveragedPhases(Cmplx[][] spectrums) {
        Cmplx[] spectrum = spectrums[0];
        int i = 0;
        while (i < this.nbBins) {
            this.sourcePhi[i].set(spectrum[i]);
            ++i;
        }
        int scale = 1;
        while (scale < 5) {
            Cmplx[] spectrum2 = spectrums[scale];
            int i2 = 0;
            while (i2 < this.nbBins) {
                this.sourcePhi[i2].add(spectrum2[i2]);
                ++i2;
            }
            ++scale;
        }
        int i3 = 0;
        while (i3 < this.nbBins) {
            float mag = this.sourcePhi[i3].magApprox();
            if (mag > Float.MIN_NORMAL) {
                this.sourcePhi[i3].mul(1.0f / mag);
            }
            ++i3;
        }
    }

    private void lockPhases(Cmplx[][] spectrums) {
        Cmplx[][] cmplxArray = spectrums;
        int n = spectrums.length;
        int n2 = 0;
        while (n2 < n) {
            Cmplx[] spectrum = cmplxArray[n2];
            int i = 0;
            while (i < this.nbBins) {
                float mag = spectrum[i].magApprox();
                spectrum[i].set(this.sourcePhi[i]);
                spectrum[i].mul(mag);
                ++i;
            }
            ++n2;
        }
    }

    protected abstract void processSpectrum(Cmplx[][] var1);

    public void stopProcessing() {
        this.mChan = null;
        this.fork = null;
        this.spoons = null;
        this.orgSpoons = null;
        this.orgDelayer = null;
        this.delayed = null;
        this.cups = null;
        this.mChan = null;
        this.spectrums = null;
        this.orgSpectrums = null;
        this.sourcePhi = null;
        this.output = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        Spoon spoon;
        this.fork.createSerialSections(factory);
        this.dish.createSerialSections(factory);
        this.spoonSerialSection = factory.createSerialSection(SPOON_SERIAL_SECTION_NAME, null);
        this.cupSerialSection = factory.createSerialSection(CUP_SERIAL_SECTION_NAME, null);
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            spoon.createSerialSections(factory);
            ++n2;
        }
        objectArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            if (spoon != null) {
                spoon.createSerialSections(factory);
            }
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).createSerialSections(factory);
            ++n2;
        }
        this.setupSrcDelayer(factory.getMtContext());
        this.delayerSerialSection = factory.createSerialSection(DELAYER_SERIAL_SECTION_NAME, (Object)this.orgDelayer);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        Spoon spoon;
        this.fork.setSerialSections(pool);
        this.dish.setSerialSections(pool);
        this.spoonSerialSection = pool.getSerialSection(SPOON_SERIAL_SECTION_NAME);
        this.cupSerialSection = pool.getSerialSection(CUP_SERIAL_SECTION_NAME);
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            spoon.setSerialSections(pool);
            ++n2;
        }
        objectArray = this.orgSpoons;
        n = this.orgSpoons.length;
        n2 = 0;
        while (n2 < n) {
            spoon = objectArray[n2];
            if (spoon != null) {
                spoon.setSerialSections(pool);
            }
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).setSerialSections(pool);
            ++n2;
        }
        this.delayerSerialSection = pool.getSerialSection(DELAYER_SERIAL_SECTION_NAME);
        this.orgDelayer = (ConcurrentDelayBuffer)this.delayerSerialSection.getUserData();
    }
}

