/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.adaptive.Cup;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.adaptive.Spoon;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public abstract class MsStftPushEffectBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private static final int NB_LAYERS = 2;
    private static final SharpInfo SHARP_INFO_IN = new SharpInfo(5500.0f, 2, 5.3f, 5500.0f, 16.0f, false, 2.0f, 44100.0f);
    private static final SharpInfo SHARP_INFO_OUT = SHARP_INFO_IN.halfOverlapCopy(2.0f);
    private static final int OUT_MUL = 2;
    private int nbBins;
    private float[][] mChan;
    private Fork fork;
    private Spoon[] spoons;
    private Cup[] cups;
    private Cmplx[][] spectrums;
    private Cmplx[] source;
    private float[] output;

    public void startProcessing(IProcessingInfo info) {
        this.mChan = new float[1][];
        this.fork = new Fork(1, SHARP_INFO_IN);
        this.spoons = new Spoon[2];
        this.cups = new Cup[2];
        int i = 0;
        while (i < 2) {
            this.spoons[i] = new Spoon(SHARP_INFO_IN, i);
            this.cups[i] = new Cup(SHARP_INFO_OUT, i, null);
            ++i;
        }
        this.nbBins = MsStftPushEffectBase.SHARP_INFO_IN.blockSize / 2 + 1;
        this.spectrums = new Cmplx[2][];
        this.source = Cmplx.newArray((int)this.nbBins);
        this.output = new float[this.fork.getInputSize() * 2];
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public int getLatency(IoDirection ioDirection) {
        return this.fork.getLatency() + this.cups[0].getLatency();
    }

    public int getFixedChunkLength() {
        return this.fork.getInputSize();
    }

    protected int getNbBins() {
        return this.spoons[0].getBlockSize() / 2 + 1;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.fork.init();
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            Spoon spoon = objectArray[n2];
            spoon.init();
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).init();
            ++n2;
        }
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        this.mChan[0] = input;
        this.fork.process(this.mChan);
        int layer = 0;
        while (layer < 2) {
            this.spectrums[layer] = this.spoons[layer].process(this.fork.getOutput(layer, 0));
            ++layer;
        }
        Cmplx[] source = this.fillSource(this.spectrums);
        this.processSpectrum(source, this.spectrums);
        Arrays.fill(this.output, 0.0f);
        int layer2 = 0;
        while (layer2 < 2) {
            this.cups[layer2].processAdd(this.spectrums[layer2], this.output);
            ++layer2;
        }
        if (length == input.length) {
            target.writeSamples(this.output);
        } else {
            float[] lastOutput = new float[length * this.output.length / input.length];
            System.arraycopy(this.output, 0, lastOutput, 0, lastOutput.length);
            target.writeSamples(lastOutput);
        }
    }

    private Cmplx[] fillSource(Cmplx[][] spectrums) {
        Cmplx[] spectrum = spectrums[0];
        int i = 0;
        while (i < this.nbBins) {
            this.source[i].set(spectrum[i]);
            ++i;
        }
        int layer = 1;
        while (layer < 2) {
            Cmplx[] spectrum2 = spectrums[layer];
            int i2 = 0;
            while (i2 < this.nbBins) {
                this.source[i2].add(spectrum2[i2]);
                ++i2;
            }
            ++layer;
        }
        return this.source;
    }

    protected abstract void processSpectrum(Cmplx[] var1, Cmplx[][] var2);

    public void stopProcessing() {
        this.mChan = null;
        this.fork = null;
        this.spoons = null;
        this.cups = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.fork.createSerialSections(factory);
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            Spoon spoon = objectArray[n2];
            spoon.createSerialSections(factory);
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).createSerialSections(factory);
            ++n2;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.fork.setSerialSections(pool);
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            Spoon spoon = objectArray[n2];
            spoon.setSerialSections(pool);
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).setSerialSections(pool);
            ++n2;
        }
    }
}

