/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.adaptive.Cup;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.adaptive.Spoon;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public abstract class MsStftSimpleEffectBase
extends EffectBase
implements ISimpleEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private static final int NB_LAYERS = 3;
    private static final SharpInfo SHARP_INFO = new SharpInfo(8192.0f, 3, 4.0f, 1024.0f, 3.0f, 44100.0f);
    private int nbBins;
    private float[][] mChan;
    private Fork fork;
    private Spoon[] spoons;
    private Cup[] cups;
    private Cmplx[][] spectrums;
    private Cmplx[] source;

    public void startProcessing(IProcessingInfo info) {
        this.mChan = new float[1][];
        this.fork = new Fork(1, SHARP_INFO);
        this.spoons = new Spoon[3];
        this.cups = new Cup[3];
        int i = 0;
        while (i < 3) {
            this.spoons[i] = new Spoon(SHARP_INFO, i);
            this.cups[i] = new Cup(SHARP_INFO, i, null);
            ++i;
        }
        this.nbBins = MsStftSimpleEffectBase.SHARP_INFO.blockSize / 2 + 1;
        this.spectrums = new Cmplx[3][];
        this.source = Cmplx.newArray((int)this.nbBins);
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public int getLatency(IoDirection ioDirection) {
        return this.fork.getLatency() + this.cups[0].getLatency();
    }

    public int getFixedChunkLength() {
        return this.fork.getInputSize();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.fork.init();
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            Spoon spoon = objectArray[n2];
            spoon.init();
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).init();
            ++n2;
        }
    }

    public void process(float[] data) {
        this.mChan[0] = data;
        this.fork.process(this.mChan);
        int layer = 0;
        while (layer < 3) {
            this.spectrums[layer] = this.spoons[layer].process(this.fork.getOutput(layer, 0));
            ++layer;
        }
        Cmplx[] source = this.fillSource(this.spectrums);
        this.processSpectrum(source, this.spectrums);
        Arrays.fill(data, 0.0f);
        int layer2 = 0;
        while (layer2 < 3) {
            this.cups[layer2].processAdd(this.spectrums[layer2], data);
            ++layer2;
        }
    }

    private Cmplx[] fillSource(Cmplx[][] spectrums) {
        Cmplx[] spectrum = spectrums[0];
        int i = 0;
        while (i < this.nbBins) {
            this.source[i].set(spectrum[i]);
            ++i;
        }
        int layer = 1;
        while (layer < 3) {
            Cmplx[] spectrum2 = spectrums[layer];
            int i2 = 0;
            while (i2 < this.nbBins) {
                this.source[i2].add(spectrum2[i2]);
                ++i2;
            }
            ++layer;
        }
        return this.source;
    }

    protected abstract void processSpectrum(Cmplx[] var1, Cmplx[][] var2);

    public void stopProcessing() {
        this.mChan = null;
        this.fork = null;
        this.spoons = null;
        this.cups = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.fork.createSerialSections(factory);
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            Spoon spoon = objectArray[n2];
            spoon.createSerialSections(factory);
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).createSerialSections(factory);
            ++n2;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.fork.setSerialSections(pool);
        Object[] objectArray = this.spoons;
        int n = this.spoons.length;
        int n2 = 0;
        while (n2 < n) {
            Spoon spoon = objectArray[n2];
            spoon.setSerialSections(pool);
            ++n2;
        }
        objectArray = this.cups;
        n = this.cups.length;
        n2 = 0;
        while (n2 < n) {
            Object cup = objectArray[n2];
            ((Cup)cup).setSerialSections(pool);
            ++n2;
        }
    }
}

