/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public abstract class PyramidPushEffectBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private final int[] RESOLUTIONS = new int[]{8192, 4096, 2048, 1024};
    private final float[] SPLIT_FREQS = new float[]{3700.0f, 6400.0f, 10000.0f};
    private final int OUT_MUL = 2;
    private int overlap = 8;
    private float[] analysisWindow;
    private float[] synthesisWindow;
    private boolean rotate;
    private float shrinkEnergyCorrection = 4.0f;
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;
    private float[] output;
    private transient float sampleRate;

    protected final int getBaseResolution() {
        return this.RESOLUTIONS[0];
    }

    protected int getOverlap() {
        return this.overlap;
    }

    protected void setOverlap(int overlap) {
        this.overlap = overlap;
    }

    protected float[] getAnalysisWindow() {
        return this.analysisWindow;
    }

    protected void setAnalysisWindow(float[] analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    protected float[] getSynthesisWindow() {
        return this.synthesisWindow;
    }

    protected void setSynthesisWindow(float[] synthesisWindow) {
        this.synthesisWindow = synthesisWindow;
    }

    protected boolean isRotate() {
        return this.rotate;
    }

    protected void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    protected float getShrinkEnergyCorrection() {
        return this.shrinkEnergyCorrection;
    }

    protected void setShrinkEnergyCorrection(float shrinkEnergyCorrection) {
        this.shrinkEnergyCorrection = shrinkEnergyCorrection;
    }

    public void startProcessing(IProcessingInfo info) {
        int blockSize = this.RESOLUTIONS[0];
        int hopSize = blockSize / this.overlap;
        int numHops = 1;
        int chunkLength = info.getHostPreferredChunkLength();
        if (chunkLength > 0 && (numHops = chunkLength / hopSize) < 1) {
            numHops = 1;
        }
        int inputSize = hopSize * numHops;
        info.negociateFixedChunkLength(inputSize);
        this.analyzer = new PyramidAnalyzer(this.RESOLUTIONS, inputSize, this.overlap, this.analysisWindow);
        this.synthesizer = new PyramidSynthesizer(this.RESOLUTIONS, inputSize * 2, this.overlap / 2, this.analysisWindow, this.synthesisWindow, null, this.shrinkEnergyCorrection, true, this.rotate ? 2.0f : 1.0f);
        this.output = new float[inputSize * 2];
        this.sampleRate = info.getSampleRate();
    }

    public boolean canWriteFasterThanRead() {
        return true;
    }

    public int getFixedChunkLength() {
        return this.analyzer.getInputSize();
    }

    public int getLatency(IoDirection ioDirection) {
        return this.synthesizer.getLatency();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.analyzer.init();
        this.synthesizer.init();
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        Cmplx[][][] spectrums = this.analyzer.analyzeInEachRes(input);
        this.splitFrequencies(spectrums);
        int r = 0;
        while (r < spectrums.length) {
            Cmplx[][] frames = spectrums[r];
            int k = 0;
            while (k < frames.length) {
                this.processSpectrum(frames[k]);
                ++k;
            }
            ++r;
        }
        this.synthesizer.synthesize(spectrums, this.output);
        if (length == input.length) {
            target.writeSamples(this.output);
        } else {
            float[] lastOutput = new float[length * this.output.length / input.length];
            System.arraycopy(this.output, 0, lastOutput, 0, lastOutput.length);
            target.writeSamples(lastOutput);
        }
    }

    private void splitFrequencies(Cmplx[][][] spectrums) {
        int r = 0;
        while (r < spectrums.length) {
            float lowFreq = r == 0 ? 0.0f : this.SPLIT_FREQS[r - 1];
            float hihFreq = r >= this.SPLIT_FREQS.length ? 24000.0f : this.SPLIT_FREQS[r];
            float lowR = lowFreq / this.sampleRate;
            float hihR = hihFreq / this.sampleRate;
            int res = this.RESOLUTIONS[r];
            int lowBin = this.cut2bin(res, lowR, -1);
            int hihBin = this.cut2bin(res, hihR, 1);
            int k = 0;
            while (k < spectrums[r].length) {
                Cmplx[] spectrum = spectrums[r][k];
                int i = 0;
                while (i < spectrum.length) {
                    if (i < lowBin || i > hihBin) {
                        spectrum[i].set(0.0f, 0.0f);
                    }
                    ++i;
                }
                ++k;
            }
            ++r;
        }
    }

    private int cut2bin(int fftSize, float freq, int rounding) {
        int nbBins = fftSize / 2 + 1;
        float offset = (float)(rounding + 1) * 0.4999f;
        int result = (int)(freq * (float)fftSize + offset);
        if (result < 0) {
            result = 0;
        } else if (result >= nbBins) {
            result = nbBins - 1;
        }
        return result;
    }

    protected abstract void processSpectrum(Cmplx[] var1);

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
        this.output = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
    }
}

