/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public abstract class PyramidSimpleEffectBase
extends EffectBase
implements ISimpleEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private static final int[] RESOLUTIONS = new int[]{8192, 4096, 2048, 1024};
    private static final float[] SPLIT_FREQS = new float[]{3700.0f, 6400.0f, 10000.0f};
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;
    private transient float sampleRate;

    public void startProcessing(IProcessingInfo info) {
        int blockSize = RESOLUTIONS[0];
        int overlap = 8;
        int hopSize = blockSize / overlap;
        int numHops = 1;
        int chunkLength = info.getHostPreferredChunkLength();
        if (chunkLength > 0 && (numHops = chunkLength / hopSize) < 1) {
            numHops = 1;
        }
        int ioSize = hopSize * numHops;
        info.negociateFixedChunkLength(ioSize);
        this.analyzer = new PyramidAnalyzer(RESOLUTIONS, ioSize, overlap, null);
        this.synthesizer = new PyramidSynthesizer(RESOLUTIONS, ioSize, overlap, null, null, null, 1.0f, false, 1.0f);
        this.sampleRate = info.getSampleRate();
    }

    public int getFixedChunkLength() {
        return this.analyzer.getInputSize();
    }

    public int getLatency(IoDirection ioDirection) {
        return this.synthesizer.getLatency();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.analyzer.init();
        this.synthesizer.init();
    }

    public void process(float[] data) {
        Cmplx[][][] spectrums = this.analyzer.analyzeInEachRes(data);
        this.splitFrequencies(spectrums);
        int r = 0;
        while (r < spectrums.length) {
            Cmplx[][] frames = spectrums[r];
            int k = 0;
            while (k < frames.length) {
                this.processSpectrum(frames[k]);
                ++k;
            }
            ++r;
        }
        this.synthesizer.synthesize(spectrums, data);
    }

    private void splitFrequencies(Cmplx[][][] spectrums) {
        int r = 0;
        while (r < spectrums.length) {
            float lowFreq = r == 0 ? 0.0f : SPLIT_FREQS[r - 1];
            float hihFreq = r >= SPLIT_FREQS.length ? 24000.0f : SPLIT_FREQS[r];
            float lowR = lowFreq / this.sampleRate;
            float hihR = hihFreq / this.sampleRate;
            int res = RESOLUTIONS[r];
            int lowBin = this.cut2bin(res, lowR, -1);
            int hihBin = this.cut2bin(res, hihR, 1);
            int k = 0;
            while (k < spectrums[r].length) {
                Cmplx[] spectrum = spectrums[r][k];
                int i = 0;
                while (i < spectrum.length) {
                    if (i < lowBin || i > hihBin) {
                        spectrum[i].set(0.0f, 0.0f);
                    }
                    ++i;
                }
                ++k;
            }
            ++r;
        }
    }

    private int cut2bin(int fftSize, float freq, int rounding) {
        int nbBins = fftSize / 2 + 1;
        float offset = (float)(rounding + 1) * 0.4999f;
        int result = (int)(freq * (float)fftSize + offset);
        if (result < 0) {
            result = 0;
        } else if (result >= nbBins) {
            result = nbBins - 1;
        }
        return result;
    }

    protected abstract void processSpectrum(Cmplx[] var1);

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
    }
}

