/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.pyramid;

import ch.tachyon.sonics.effect.base.stft.StftAnalyzerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class PyramidAnalyzer
implements IHasSerialSections {
    private static final String SECTION_NAME = "ch.tachyon.sonics.pyramid.analyzer";
    private final String name;
    private final int nbResolutions;
    private final int inputSize;
    private final int overlap;
    private final StftAnalyzerMulti[] analyzers;
    private ISerialSection ss = new DummySerialSection();
    private long clockDiv = 1L;

    public PyramidAnalyzer(int[] resolutions, int inputSize, int overlap, float[] analysisWindow) {
        this("", resolutions, inputSize, overlap, analysisWindow);
    }

    public PyramidAnalyzer(String name, int[] resolutions, int inputSize, int overlap, float[] analysisWindow) {
        this.name = name.equals("") ? "" : "." + name;
        this.nbResolutions = resolutions.length;
        this.inputSize = inputSize;
        this.overlap = overlap;
        this.analyzers = new StftAnalyzerMulti[this.nbResolutions];
        int i = 0;
        while (i < this.nbResolutions) {
            int hopSize;
            int blockSize0 = resolutions[i];
            int blockSize = AudioMath.getCeilingPowerOf2((int)blockSize0);
            if (analysisWindow == null) {
                analysisWindow = WindowsFactory.getHannWindow(blockSize);
            }
            if (inputSize % (hopSize = blockSize / overlap) != 0) {
                throw new IllegalArgumentException();
            }
            this.analyzers[i] = new StftAnalyzerMulti(blockSize0, hopSize, inputSize / hopSize, PyramidAnalyzer.shrinkBy(analysisWindow, blockSize, (float)resolutions[0] / (float)blockSize0), true);
            this.analyzers[i].setName(String.valueOf(name) + String.valueOf(blockSize0));
            ++i;
        }
    }

    private static float[] shrinkBy(float[] window, int targetSize, float amount) {
        if (window.length == targetSize && amount == 1.0f) {
            return window;
        }
        if (amount != 1.0f) {
            float[] temp = new float[window.length];
            System.arraycopy(window, 0, temp, 0, window.length);
            Windows.shrink((float[])temp, (float)amount, (boolean)false);
            window = temp;
        }
        float[] result = new float[targetSize];
        int offset = (window.length - targetSize) / 2;
        int i = 0;
        while (i < targetSize) {
            result[i] = window[i + offset];
            ++i;
        }
        return result;
    }

    public void setClockDiv(long clockDiv) {
        this.clockDiv = clockDiv;
    }

    public void init() {
        StftAnalyzerMulti[] stftAnalyzerMultiArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzerMulti analyzer = stftAnalyzerMultiArray[n2];
            analyzer.init();
            ++n2;
        }
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public int getNumHops(int res) {
        return this.analyzers[res].getNumHops();
    }

    public long getClock() {
        return this.ss.getClock();
    }

    public int getBlockSize(int res) {
        return this.analyzers[res].getBlockSize();
    }

    public int getOverlap() {
        return this.overlap;
    }

    public int getLatency() {
        return this.analyzers[0].getLatency();
    }

    public Cmplx[][][] analyzeInEachRes(float[] input) {
        if (input.length != this.inputSize) {
            throw new IllegalArgumentException("The length of the input (" + input.length + ") does not match the expected length " + this.inputSize);
        }
        Cmplx[][][] results = new Cmplx[this.nbResolutions][][];
        int[] baseIndexes = new int[this.nbResolutions];
        int i = 0;
        while (i < this.nbResolutions) {
            baseIndexes[i] = this.analyzers[i].pushInput(input, this.ss.getClock() / this.clockDiv);
            ++i;
        }
        this.ss.sync();
        i = 0;
        while (i < this.nbResolutions) {
            results[i] = this.analyzers[i].analyzePushedInput(baseIndexes[i]);
            ++i;
        }
        return results;
    }

    public Cmplx[][][] analyze(float[][] inputs) {
        if (inputs.length != this.nbResolutions) {
            throw new IllegalArgumentException();
        }
        if (inputs[0].length != this.inputSize) {
            throw new IllegalArgumentException("The length of the input (" + inputs[0].length + ") does not match the expected length " + this.inputSize);
        }
        Cmplx[][][] results = new Cmplx[this.nbResolutions][][];
        int[] baseIndexes = new int[this.nbResolutions];
        int i = 0;
        while (i < this.nbResolutions) {
            baseIndexes[i] = this.analyzers[i].pushInput(inputs[i], this.ss.getClock() / this.clockDiv);
            ++i;
        }
        this.ss.sync();
        i = 0;
        while (i < this.nbResolutions) {
            results[i] = this.analyzers[i].analyzePushedInput(baseIndexes[i]);
            ++i;
        }
        return results;
    }

    public void pass() {
        if (this.clockDiv == 1L) {
            throw new IllegalStateException("You must set clockDiv to use pass()");
        }
        this.ss.sync();
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        StftAnalyzerMulti[] stftAnalyzerMultiArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzerMulti analyzer = stftAnalyzerMultiArray[n2];
            analyzer.createSerialSections(factory);
            ++n2;
        }
        this.ss = factory.createSerialSection(SECTION_NAME + this.name, null);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.ss = pool.getSerialSection(SECTION_NAME + this.name);
        StftAnalyzerMulti[] stftAnalyzerMultiArray = this.analyzers;
        int n = this.analyzers.length;
        int n2 = 0;
        while (n2 < n) {
            StftAnalyzerMulti analyzer = stftAnalyzerMultiArray[n2];
            analyzer.setSerialSections(pool);
            ++n2;
        }
    }
}

