/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.pyramid;

import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public class PyramidFourierEngine
implements IFourierEngine {
    private FourierSpec specs;
    private float sampleRate;
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;
    private int[] fftSizes;
    private Cmplx[][][] filtereds;
    private float[] output;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void startProcessing(IProcessingInfo info) {
        int chunkLength;
        int[] resolutions = this.specs.getPyramidResolutions();
        this.fftSizes = new int[resolutions.length];
        int i = 0;
        while (i < resolutions.length) {
            this.fftSizes[i] = AudioMath.getCeilingPowerOf2((int)resolutions[i]);
            ++i;
        }
        int hopSize = this.specs.getInputHopSize();
        int numHops = 1;
        if (!this.specs.getMinimizeNumHops() && (chunkLength = info.getHostPreferredChunkLength()) > 0 && (numHops = chunkLength / hopSize) < 1) {
            numHops = 1;
        }
        int inputSize = hopSize * numHops;
        info.negociateFixedChunkLength(inputSize);
        int overlap = this.specs.getIntOverlap();
        int outMul = this.specs.getOutputHopSize() / this.specs.getInputHopSize();
        this.sampleRate = info.getSampleRate();
        this.analyzer = new PyramidAnalyzer(resolutions, inputSize, overlap, this.specs.getAnalysisWindow());
        this.synthesizer = new PyramidSynthesizer(resolutions, inputSize * outMul, overlap / outMul, this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getPostFftProcessor(), this.specs.getSynthesisShrink(), this.specs.getEnergyCorrection(), this.specs.getTimeScale());
        this.synthesizer.setFourierLatency(this.specs.getFourierLatency());
    }

    public int getFixedChunkLength() {
        return this.analyzer.getInputSize();
    }

    public int getLatency() {
        int result = this.synthesizer.getLatency();
        return result += (int)((float)this.synthesizer.getBaseBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
    }

    public int getNbScales() {
        return this.specs.getNbLayers();
    }

    public int getNbResolutions() {
        return this.specs.getNbPyramidResolutions();
    }

    public int getNbBins(int layer) {
        return this.fftSizes[layer] / 2 + 1;
    }

    public int getNbBins() {
        return -1;
    }

    public int getEffectiveResolution(int layer) {
        return this.specs.getPyramidResolutions()[layer];
    }

    public int getNumHops(int scale) {
        return this.analyzer.getNumHops(scale);
    }

    public int getInputHopSize() {
        return this.analyzer.getInputSize();
    }

    public int getDistanceBetweenFrames(int res) {
        return this.analyzer.getBlockSize(res) / this.analyzer.getOverlap();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.analyzer.init();
        this.synthesizer.init();
        if (this.specs.getTimeScale() != 1.0f) {
            this.output = new float[this.synthesizer.getOutputSize()];
        }
        this.filtereds = new Cmplx[this.getNbResolutions()][][];
        int r = 0;
        while (r < this.filtereds.length) {
            int numHops = this.analyzer.getNumHops(r);
            this.filtereds[r] = new Cmplx[numHops][];
            int k = 0;
            while (k < numHops) {
                this.filtereds[r][k] = Cmplx.newArray((int)(this.fftSizes[r] / 2 + 1));
                ++k;
            }
            ++r;
        }
    }

    public float[] process(float[] input, ISpectrumProcessor processor) {
        long clock = this.analyzer.getClock();
        Cmplx[][][] spectrums = this.analyzer.analyzeInEachRes(input);
        this.splitFrequencies(spectrums, this.filtereds);
        int step = 0;
        while (step < processor.getNumSteps()) {
            int r = 0;
            while (r < spectrums.length) {
                Cmplx[][] srcFrames = this.specs.getRequiresSource() ? spectrums[r] : this.filtereds[r];
                Cmplx[][] dstFrames = this.filtereds[r];
                int numHops = this.analyzer.getNumHops(r);
                assert (dstFrames.length == numHops && srcFrames.length == numHops);
                int k = 0;
                while (k < dstFrames.length) {
                    processor.process(r, r, srcFrames[k], dstFrames[k], k, clock * (long)numHops + (long)k, step);
                    ++k;
                }
                ++r;
            }
            processor.afterStep(step, clock);
            ++step;
        }
        float[] output = this.output == null ? input : this.output;
        this.synthesizer.synthesize(this.filtereds, output);
        if (this.specs.getPostLockedProcessor() != null) {
            this.specs.getPostLockedProcessor().postProcess(output, null);
        }
        return output;
    }

    private void splitFrequencies(Cmplx[][][] spectrums, Cmplx[][][] filtereds) {
        float[] splitFreqs = this.specs.getSplitFreqs();
        int r = 0;
        while (r < spectrums.length) {
            int hihBin;
            float lowFreq = r == 0 ? 0.0f : splitFreqs[r - 1];
            float hihFreq = r >= splitFreqs.length ? this.sampleRate / 2.0f : splitFreqs[r];
            float lowR = lowFreq / this.sampleRate;
            float hihR = hihFreq / this.sampleRate;
            int res = this.fftSizes[r];
            int lowBin = this.cut2bin(res, lowR);
            if (r < this.fftSizes.length - 1) {
                hihBin = this.cut2bin(this.fftSizes[r + 1], hihR);
                hihBin = hihBin * this.fftSizes[r] / this.fftSizes[r + 1];
            } else {
                hihBin = this.fftSizes[r] / 2 + 1;
            }
            int k = 0;
            while (k < spectrums[r].length) {
                Cmplx[] spectrum = spectrums[r][k];
                Cmplx[] filtered = filtereds[r][k];
                int i = 0;
                while (i < spectrum.length) {
                    if (i < lowBin || i >= hihBin) {
                        filtered[i].set(0.0f, 0.0f);
                    } else if (i == lowBin && i != 0) {
                        filtered[i].set(spectrum[i].re * 0.8f, spectrum[i].im * 0.8f);
                    } else {
                        filtered[i].set(spectrum[i]);
                    }
                    ++i;
                }
                ++k;
            }
            ++r;
        }
    }

    private int cut2bin(int fftSize, float freq) {
        int nbBins = fftSize / 2 + 1;
        int result = (int)(freq * (float)fftSize + 0.5f);
        if (result < 0) {
            result = 0;
        } else if (result >= nbBins) {
            result = nbBins - 1;
        }
        return result;
    }

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
        this.filtereds = null;
        this.output = null;
        this.specs = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
    }
}

