/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.pyramid;

import ch.tachyon.sonics.effect.base.fourier.IFourierLatency;
import ch.tachyon.sonics.effect.base.fourier.IPostFftProcessor;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizerMulti;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.sonics.effect.utils.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class PyramidSynthesizer
implements IHasSerialSections {
    private static final String SECTION_NAME_1 = "ch.tachyon.sonics.pyramid.synthesizer";
    private static final String SECTION_NAME_2 = "ch.tachyon.sonics.pyramid.delayer";
    private final String name;
    private final int nbResolutions;
    private final int[] resolutions;
    private final int outputSize;
    private final int overlap;
    private final float timeScale;
    private final StftSynthesizerMulti[] synthesizers;
    private final float[][] outputs;
    private ConcurrentDelayBuffer[] delayBuffers;
    private ISerialSection ss1 = new DummySerialSection();
    private ISerialSection ss2 = new DummySerialSection();
    private long clockDiv = 1L;
    private IFourierLatency fourierLatency;

    public PyramidSynthesizer(int[] resolutions, int outputSize, int overlap, float[] analysisWindow, float[] synthesisWindow, IPostFftProcessor postFftProcessor, float synthesisShrink, boolean energyCorrection, float timeScale) {
        this("", resolutions, outputSize, overlap, analysisWindow, synthesisWindow, postFftProcessor, synthesisShrink, energyCorrection, timeScale);
    }

    public PyramidSynthesizer(String name, int[] resolutions, int outputSize, int overlap, float[] analysisWindow, float[] synthesisWindow, final IPostFftProcessor postFftProcessor, float synthesisShrink, boolean energyCorrection, float timeScale) {
        this.name = name.equals("") ? "" : "." + name;
        this.resolutions = new int[resolutions.length];
        System.arraycopy(resolutions, 0, this.resolutions, 0, resolutions.length);
        this.nbResolutions = resolutions.length;
        this.outputSize = outputSize;
        this.overlap = overlap;
        this.synthesizers = new StftSynthesizerMulti[this.nbResolutions];
        int i = 0;
        while (i < this.nbResolutions) {
            int hopSize;
            if (i > 0 && resolutions[i] >= resolutions[i - 1]) {
                throw new IllegalArgumentException("Resolutions must be decreasing");
            }
            int blockSize0 = resolutions[i];
            int blockSize = AudioMath.getCeilingPowerOf2((int)blockSize0);
            if (analysisWindow == null) {
                analysisWindow = WindowsFactory.getHannWindow(blockSize);
            }
            if (synthesisWindow == null) {
                synthesisWindow = WindowsFactory.getHannWindow(blockSize);
            }
            if (outputSize % (hopSize = blockSize / overlap) != 0) {
                throw new IllegalArgumentException();
            }
            this.synthesizers[i] = new StftSynthesizerMulti(blockSize, hopSize, outputSize / hopSize, PyramidSynthesizer.shrinkBy(analysisWindow, blockSize, (float)resolutions[0] / (float)blockSize0), PyramidSynthesizer.shrinkBy(synthesisWindow, blockSize, (float)resolutions[0] / (float)blockSize0), synthesisShrink, energyCorrection){

                protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                    super.backwardFFT(spectrum, output);
                    if (postFftProcessor != null) {
                        postFftProcessor.postProcess(output);
                    }
                }
            };
            this.synthesizers[i].setName(String.valueOf(name) + String.valueOf(blockSize0));
            ++i;
        }
        this.outputs = new float[this.nbResolutions][outputSize];
        this.timeScale = timeScale;
    }

    private static float[] shrinkBy(float[] window, int targetSize, float amount) {
        if (window.length == targetSize && amount == 1.0f) {
            return window;
        }
        if (amount != 1.0f) {
            float[] temp = new float[window.length];
            System.arraycopy(window, 0, temp, 0, window.length);
            Windows.shrink((float[])temp, (float)amount, (boolean)false);
            window = temp;
        }
        float[] result = new float[targetSize];
        int offset = (window.length - targetSize) / 2;
        int i = 0;
        while (i < targetSize) {
            result[i] = window[i + offset];
            ++i;
        }
        return result;
    }

    public void setClockDiv(long clockDiv) {
        this.clockDiv = clockDiv;
    }

    public void setFourierLatency(IFourierLatency fourierLatency) {
        this.fourierLatency = fourierLatency;
    }

    public void init() {
        StftSynthesizerMulti[] stftSynthesizerMultiArray = this.synthesizers;
        int n = this.synthesizers.length;
        int n2 = 0;
        while (n2 < n) {
            StftSynthesizerMulti synthesizer = stftSynthesizerMultiArray[n2];
            synthesizer.init();
            ++n2;
        }
    }

    public int getOutputSize() {
        return this.outputSize;
    }

    public int getBaseBlockSize() {
        return this.synthesizers[0].getBlockSize();
    }

    public int getOverlap() {
        return this.overlap;
    }

    public void synthesize(Cmplx[][][] spectrums, float[] output) {
        this.synthesize(spectrums, output, -1, output);
    }

    public void synthesize(Cmplx[][][] spectrums, float[] output1, int midLayer, float[] output2) {
        long clock = this.ss1.getClock() / this.clockDiv;
        int i = 0;
        while (i < this.nbResolutions) {
            this.synthesizers[i].preSynthesize(spectrums[i], clock);
            ++i;
        }
        this.ss1.sync();
        i = 0;
        while (i < this.nbResolutions) {
            this.synthesizers[i].renderResult(this.outputs[i], clock);
            if (i > 0) {
                this.delayBuffers[i].push(this.outputs[i], clock);
            }
            ++i;
        }
        this.ss2.sync();
        float[] output = output1;
        int i2 = 0;
        while (i2 < this.nbResolutions) {
            if (i2 == midLayer) {
                Arrays.fill(output2, 0.0f);
                output = output2;
            }
            if (i2 == 0) {
                System.arraycopy(this.outputs[0], 0, output, 0, output.length);
            } else {
                this.delayBuffers[i2].pop(this.outputs[i2], clock);
                int j = 0;
                while (j < output.length) {
                    int n = j;
                    output[n] = output[n] + this.outputs[i2][j];
                    ++j;
                }
            }
            ++i2;
        }
    }

    public void pass() {
        if (this.clockDiv == 1L) {
            throw new IllegalStateException("You must set clockDiv to use pass()");
        }
        this.ss1.sync();
        this.ss2.sync();
    }

    public int getLatency() {
        return this.latencyOf(0);
    }

    private int latencyOf(int resolution) {
        int result = this.synthesizers[resolution].getLatency();
        if (this.fourierLatency != null) {
            result += this.fourierLatency.getFourierLatency(this.synthesizers[resolution].getHopSize(), resolution, resolution);
        }
        return result;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        StftSynthesizerMulti[] stftSynthesizerMultiArray = this.synthesizers;
        int n = this.synthesizers.length;
        int n2 = 0;
        while (n2 < n) {
            StftSynthesizerMulti synthesizer = stftSynthesizerMultiArray[n2];
            synthesizer.createSerialSections(factory);
            ++n2;
        }
        int latency = this.latencyOf(0);
        if (this.timeScale != 1.0f) {
            latency += (int)((float)AudioMath.getCeilingPowerOf2((int)this.resolutions[0]) / 2.0f * (this.timeScale - 1.0f) + 0.5f);
        }
        this.delayBuffers = new ConcurrentDelayBuffer[this.nbResolutions];
        int i = 1;
        while (i < this.nbResolutions) {
            int subLatency = this.latencyOf(i);
            if (this.timeScale != 1.0f) {
                subLatency += (int)((float)AudioMath.getCeilingPowerOf2((int)this.resolutions[i]) / 2.0f * (this.timeScale - 1.0f) + 0.5f);
            }
            assert (subLatency <= latency);
            int correction = latency - subLatency;
            int capacity = this.outputSize * factory.getMtContext().getSerialRunningMaxSkew() + correction;
            this.delayBuffers[i] = new ConcurrentDelayBuffer(correction, capacity, this.outputSize);
            ++i;
        }
        this.ss1 = factory.createSerialSection(SECTION_NAME_1 + this.name, null);
        this.ss2 = factory.createSerialSection(SECTION_NAME_2 + this.name, (Object)this.delayBuffers);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.ss1 = pool.getSerialSection(SECTION_NAME_1 + this.name);
        this.ss2 = pool.getSerialSection(SECTION_NAME_2 + this.name);
        this.delayBuffers = (ConcurrentDelayBuffer[])this.ss2.getUserData();
        StftSynthesizerMulti[] stftSynthesizerMultiArray = this.synthesizers;
        int n = this.synthesizers.length;
        int n2 = 0;
        while (n2 < n) {
            StftSynthesizerMulti synthesizer = stftSynthesizerMultiArray[n2];
            synthesizer.setSerialSections(pool);
            ++n2;
        }
    }
}

