/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft;

import ch.tachyon.sonics.effect.base.stft.IStftAnalyzer;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.math.Cmplx;

public class StftAnalyzerSingle
implements IStftAnalyzer {
    private final int blockSize;
    private final int hopSize;
    private final int olaSize;
    private final int numHops;
    private float[] input;
    private BooFFT fft;
    private float[] splitBuffer;
    private int splitIndex;
    private float[] analysisWindow;
    private float[] processBuffer;
    private Cmplx[][] spectrum;
    private long clock;

    public StftAnalyzerSingle(int blockSize0, int hopSize, int numHops, float[] analysisWindow) {
        int blockSize;
        this.blockSize = blockSize = AudioMath.getCeilingPowerOf2((int)blockSize0);
        this.hopSize = hopSize;
        this.olaSize = blockSize - hopSize;
        this.numHops = numHops;
        this.analysisWindow = analysisWindow;
        this.fft = BooFFT.getInstance((int)(blockSize / 2));
        this.splitBuffer = new float[this.olaSize];
        this.processBuffer = new float[blockSize];
        this.spectrum = Cmplx.newArray((int)numHops, (int)(blockSize / 2 + 1));
        this.clock = 0L;
    }

    BooFFT getFFT() {
        return this.fft;
    }

    float[] getProcessBuffer() {
        return this.processBuffer;
    }

    public void init() {
    }

    public int pushInput(float[] input, long clock) {
        if (input.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException();
        }
        this.input = input;
        return 0;
    }

    public Cmplx[][] analyze(float[] input) {
        this.pushInput(input, 0L);
        return this.analyzePushedInput(0);
    }

    public Cmplx[][] analyzePushedInput(int baseIndex) {
        int k = 0;
        while (k < this.numHops) {
            int offset = this.hopSize * k;
            int i = 0;
            while (i < this.olaSize) {
                this.processBuffer[i] = this.splitBuffer[(i + this.splitIndex) % this.olaSize];
                ++i;
            }
            i = 0;
            while (i < this.hopSize) {
                this.processBuffer[i + this.olaSize] = this.input[i + offset];
                ++i;
            }
            i = 0;
            while (i < this.hopSize) {
                this.splitBuffer[(i + this.splitIndex) % this.olaSize] = this.input[i + offset];
                ++i;
            }
            this.splitIndex = (this.splitIndex + this.hopSize) % this.olaSize;
            i = 0;
            while (i < this.blockSize) {
                int n = i;
                this.processBuffer[n] = this.processBuffer[n] * this.analysisWindow[i];
                ++i;
            }
            this.fft.forwR2C(this.processBuffer, this.spectrum[k]);
            ++k;
        }
        ++this.clock;
        return this.spectrum;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getNumHops() {
        return this.numHops;
    }

    public int getInputSize() {
        return this.hopSize * this.numHops;
    }

    public int getOverlap() {
        return this.blockSize / this.hopSize;
    }

    public int getNbBins() {
        return this.blockSize / 2 + 1;
    }

    public int getLatency() {
        return this.blockSize / 2 - this.hopSize;
    }

    public long getClock() {
        return this.clock;
    }

    public void setName(String name) {
    }

    public void createSerialSections(ISerialSectionFactory factory) {
    }

    public void setSerialSections(ISerialSectionPool pool) {
    }
}

