/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft;

import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.IPostFftProcessor;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.base.stft.IStftAnalyzer;
import ch.tachyon.sonics.effect.base.stft.IStftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzerMulti;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzerSingle;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizerMulti;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizerSingle;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.math.Cmplx;

public class StftFourierEngine
implements IFourierEngine {
    private FourierSpec specs;
    private IStftAnalyzer analyzer;
    private IStftSynthesizer synthesizer;
    private float[] output;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void startProcessing(IProcessingInfo info) {
        int hopSize = this.specs.getInputHopSize();
        int numHops = 1;
        if (this.specs.getMultihop()) {
            int chunkLength;
            if (this.specs.getPreferredHopSize() != null) {
                int ioSize;
                int negotiatedSize;
                chunkLength = this.specs.getPreferredHopSize();
                numHops = chunkLength / hopSize;
                if (numHops < 1) {
                    numHops = 1;
                }
                if ((negotiatedSize = info.negociateFixedChunkLength(ioSize = hopSize * numHops)) % hopSize == 0) {
                    numHops = negotiatedSize / hopSize;
                }
            } else {
                chunkLength = info.getHostPreferredChunkLength();
                if (chunkLength > 0 && (numHops = chunkLength / hopSize) < 1) {
                    numHops = 1;
                }
                int ioSize = hopSize * numHops;
                info.negociateFixedChunkLength(ioSize);
            }
        }
        final IPostFftProcessor postFftProcessor = this.specs.getPostFftProcessor();
        if (info.getMtContext().isMultiCore()) {
            this.analyzer = new StftAnalyzerMulti(this.specs.getBaseResolution(), hopSize, numHops, this.specs.getAnalysisWindow(), true);
            this.synthesizer = new StftSynthesizerMulti(this.specs.getBaseResolution(), this.specs.getOutputHopSize(), numHops, this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getSynthesisShrink(), true){

                protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                    super.backwardFFT(spectrum, output);
                    if (postFftProcessor != null) {
                        postFftProcessor.postProcess(output);
                    }
                }
            };
        } else {
            this.analyzer = new StftAnalyzerSingle(this.specs.getBaseResolution(), hopSize, numHops, this.specs.getAnalysisWindow());
            this.synthesizer = new StftSynthesizerSingle(this.specs.getBaseResolution(), this.specs.getOutputHopSize(), numHops, this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getSynthesisShrink(), true, (StftAnalyzerSingle)this.analyzer){

                protected void backwardFFT(Cmplx[] spectrum, float[] output) {
                    super.backwardFFT(spectrum, output);
                    if (postFftProcessor != null) {
                        postFftProcessor.postProcess(output);
                    }
                }
            };
        }
    }

    public int getFixedChunkLength() {
        return this.analyzer.getInputSize();
    }

    public int getLatency() {
        int result = this.synthesizer.getLatency();
        if (this.specs.getFourierLatency() != null) {
            result += this.specs.getFourierLatency().getFourierLatency(this.synthesizer.getHopSize(), 0, 0);
        }
        return result += (int)((float)this.synthesizer.getBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
    }

    public int getNbScales() {
        return 1;
    }

    public int getNbResolutions() {
        return 1;
    }

    public int getNbBins(int layer) {
        return this.getNbBins();
    }

    public int getNbBins() {
        return this.specs.getBaseResolution() / 2 + 1;
    }

    public int getEffectiveResolution(int layer) {
        return this.specs.getBaseResolution();
    }

    public int getNumHops(int scale) {
        return this.analyzer.getNumHops();
    }

    public int getInputHopSize() {
        return this.analyzer.getInputSize();
    }

    public int getDistanceBetweenFrames(int res) {
        return this.analyzer.getHopSize();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.analyzer.init();
        this.synthesizer.init();
        if (this.specs.getTimeScale() != 1.0f) {
            this.output = new float[(int)((float)this.getFixedChunkLength() * this.specs.getTimeScale() + 0.5f)];
        }
    }

    public float[] process(float[] input, ISpectrumProcessor processor) {
        long clock = this.analyzer.getClock();
        int numHops = this.analyzer.getNumHops();
        Cmplx[][] spectrums = this.analyzer.analyze(input);
        assert (spectrums.length == numHops);
        int step = 0;
        while (step < processor.getNumSteps()) {
            int k = 0;
            while (k < spectrums.length) {
                processor.process(0, 0, spectrums[k], spectrums[k], k, clock * (long)numHops + (long)k, step);
                ++k;
            }
            processor.afterStep(step, clock);
            ++step;
        }
        float[] output = this.output == null ? input : this.output;
        this.synthesizer.synthesize(spectrums, output);
        return output;
    }

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
        this.output = null;
        this.specs = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
    }
}

