/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft;

import ch.tachyon.sonics.effect.base.stft.IStftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.StftBufferArr;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.utils.Debug;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftSynthesizerMulti
implements IHasSerialSections,
IStftSynthesizer {
    private static final String SECTION_NAME = "ch.tachyon.sonics.stft.synthesizer";
    private final int blockSize;
    private final int hopSize;
    private final int numHops;
    private final int overlap;
    private final float[] analysisWindow;
    private final float[] synthesisWindow;
    private final float synthesisShrink;
    private final boolean energyCorrection;
    private float[] invWindow;
    private BooFFT fft;
    private int numSections;
    private StftBufferArr olaBuffers;
    private String name;
    protected ISerialSection ss = new DummySerialSection();
    private float[][] processBuffers;
    private float[] olaBuffer;
    private int olaIndex;

    public StftSynthesizerMulti(int blockSize, int hopSize, int numHops, float[] analysisWindow, float[] synthesisWindow) {
        this(blockSize, hopSize, numHops, analysisWindow, synthesisWindow, 1.0f, false);
    }

    public StftSynthesizerMulti(int blockSize0, int hopSize, int numHops, float[] analysisWindow, float[] synthesisWindow, float synthesisShrink, boolean energyCorrection) {
        int blockSize = AudioMath.getCeilingPowerOf2((int)blockSize0);
        float wShrink = (float)blockSize / (float)blockSize0;
        this.blockSize = blockSize;
        this.hopSize = hopSize;
        this.numHops = numHops;
        this.overlap = (blockSize + hopSize - 1) / hopSize;
        this.numSections = numHops + this.overlap;
        if (analysisWindow == null) {
            analysisWindow = WindowsFactory.getHannWindow(blockSize);
        }
        if (synthesisWindow == null) {
            synthesisWindow = analysisWindow;
        }
        this.analysisWindow = analysisWindow;
        this.synthesisWindow = synthesisWindow;
        this.synthesisShrink = synthesisShrink * wShrink;
        if (synthesisShrink >= (float)this.overlap) {
            throw new IllegalArgumentException("Cannot shrink more than overlap");
        }
        this.energyCorrection = energyCorrection;
    }

    public void init() {
        this.fft = BooFFT.getInstance((int)(this.blockSize / 2));
        this.invWindow = new float[this.hopSize];
        boolean result = Windows.fillInverseWindow((float[])this.analysisWindow, (float[])this.synthesisWindow, (float[])this.invWindow, (int)this.blockSize, (int)this.hopSize);
        if (!result) {
            Debug.warn((String)"Cannot create inverse window", (Object[])new Object[0]);
        }
    }

    public void synthesize(Cmplx[][] spectrums, float[] output) {
        if (output.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        long clock = this.ss.getClock();
        if (this.olaBuffers != null) {
            this.preSynthesize(spectrums, clock);
            this.ss.sync();
            this.renderResult(output, clock);
        } else {
            int hopIndex = 0;
            while (hopIndex < this.numHops) {
                this.preSynthesizeOneCore(spectrums, hopIndex);
                this.renderResultOneCore(output, hopIndex);
                ++hopIndex;
            }
        }
    }

    public void preSynthesize(Cmplx[][] spectrums, long clock) {
        int outputIndex;
        int runIndex = outputIndex = (int)(clock * (long)this.numHops % (long)this.numSections);
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            if (this.olaBuffers == null) {
                this.preSynthesizeOneCore(spectrums, hopIndex);
            } else {
                float[] outputBlock = this.olaBuffers.buffers[runIndex];
                this.backwardFFT(spectrums[hopIndex], outputBlock);
                this.applySynthesisWindow(outputBlock);
                runIndex = (runIndex + 1) % this.numSections;
            }
            ++hopIndex;
        }
    }

    public void renderResult(float[] output, long clock) {
        if (output.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size. Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        int outputIndex = (int)(clock * (long)this.numHops % (long)this.numSections);
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            if (this.olaBuffers == null) {
                this.renderResultOneCore(output, hopIndex);
            } else {
                this.overlapAdd(output, outputIndex, hopIndex);
                outputIndex = (outputIndex + 1) % this.numSections;
            }
            ++hopIndex;
        }
    }

    private void preSynthesizeOneCore(Cmplx[][] spectrums, int hopIndex) {
        this.backwardFFT(spectrums[hopIndex], this.processBuffers[hopIndex]);
        this.applySynthesisWindow(this.processBuffers[hopIndex]);
    }

    private void renderResultOneCore(float[] output, int hopIndex) {
        int offset = this.hopSize * hopIndex;
        int olaSize = this.blockSize - this.hopSize;
        int i = 0;
        while (i < this.hopSize) {
            output[i + offset] = (this.olaBuffer[(i + this.olaIndex) % olaSize] + this.processBuffers[hopIndex][i]) * this.invWindow[i];
            ++i;
        }
        this.olaIndex = (this.olaIndex + this.hopSize) % olaSize;
        i = 0;
        while (i < olaSize - this.hopSize) {
            int n = (i + this.olaIndex) % olaSize;
            this.olaBuffer[n] = this.olaBuffer[n] + this.processBuffers[hopIndex][i + this.hopSize];
            ++i;
        }
        i = olaSize - this.hopSize;
        while (i < olaSize) {
            this.olaBuffer[(i + this.olaIndex) % olaSize] = this.processBuffers[hopIndex][i + this.hopSize];
            ++i;
        }
    }

    protected void backwardFFT(Cmplx[] spectrum, float[] output) {
        this.fft.backC2R(spectrum, output);
    }

    protected void applySynthesisWindow(float[] output) {
        block6: {
            block5: {
                if (!this.energyCorrection || this.synthesisShrink == 1.0f) break block5;
                float energyCorrection = 1.0f;
                float maxCorrection = (float)Math.sqrt(this.synthesisShrink);
                int blockSize = output.length;
                int cellSize = (int)((float)blockSize / this.synthesisShrink + 0.5f);
                int cellStart = (blockSize - cellSize) / 2;
                int cellStop = cellStart + cellSize;
                float cellEnergy = 0.0f;
                float blockEnergy = 0.0f;
                int i = 0;
                while (i < blockSize) {
                    float p = output[i] * output[i];
                    blockEnergy += p;
                    if (i >= cellStart && i < cellStop) {
                        cellEnergy += p;
                    }
                    ++i;
                }
                if (cellEnergy > 0.0f && (energyCorrection = (float)Math.sqrt(blockEnergy / cellEnergy)) > maxCorrection) {
                    energyCorrection = maxCorrection;
                }
                i = 0;
                while (i < output.length) {
                    int n = i;
                    output[n] = output[n] * (this.synthesisWindow[i] * energyCorrection);
                    ++i;
                }
                break block6;
            }
            if (this.synthesisWindow == null) break block6;
            int i = 0;
            while (i < output.length) {
                int n = i;
                output[n] = output[n] * this.synthesisWindow[i];
                ++i;
            }
        }
    }

    private void overlapAdd(float[] output, int outputIndex, int hopIndex) {
        int outputOffset = this.hopSize * hopIndex;
        int shift = this.overlap - 1;
        int bufferIndex = (outputIndex + this.numSections - shift) % this.numSections;
        int bufferOffset = shift * this.hopSize;
        float[] block = this.olaBuffers.buffers[bufferIndex];
        int i = 0;
        while (i < this.hopSize) {
            output[outputOffset + i] = block[bufferOffset + i];
            ++i;
        }
        int k = 1;
        while (k < this.overlap) {
            int shift2 = this.overlap - k - 1;
            int bufferIndex2 = (outputIndex + this.numSections - shift2) % this.numSections;
            int bufferOffset2 = shift2 * this.hopSize;
            float[] block2 = this.olaBuffers.buffers[bufferIndex2];
            int i2 = 0;
            while (i2 < this.hopSize) {
                int n = outputOffset + i2;
                output[n] = output[n] + block2[bufferOffset2 + i2];
                ++i2;
            }
            ++k;
        }
        int i3 = 0;
        while (i3 < this.hopSize) {
            int n = outputOffset + i3;
            output[n] = output[n] * this.invWindow[i3];
            ++i3;
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getNumHops() {
        return this.numHops;
    }

    public int getOutputSize() {
        return this.hopSize * this.numHops;
    }

    public int getLatency() {
        return this.blockSize - this.hopSize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String sectionName() {
        if (this.name == null) {
            return SECTION_NAME;
        }
        return "ch.tachyon.sonics.stft.synthesizer " + this.name;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        assert (this.olaBuffers == null);
        if (factory.getMtContext().isMultiCore()) {
            this.numSections = factory.getMtContext().getSerialRunningMaxSkew() * this.numHops + this.overlap;
            this.olaBuffers = new StftBufferArr(this.blockSize, this.numSections, true);
            this.ss = factory.createSerialSection(this.sectionName(), (Object)this.olaBuffers);
        } else {
            this.processBuffers = new float[this.numHops][this.blockSize];
            this.olaBuffer = new float[this.blockSize - this.hopSize];
            this.olaIndex = 0;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.numSections = pool.getMtContext().getSerialRunningMaxSkew() * this.numHops + this.overlap;
        this.ss = pool.getSerialSection(this.sectionName());
        this.olaBuffers = (StftBufferArr)this.ss.getUserData();
    }
}

