/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft;

import ch.tachyon.sonics.effect.base.stft.IStftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzerSingle;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import ch.tachyon.tunnel.utils.Debug;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftSynthesizerSingle
implements IStftSynthesizer {
    private final int blockSize;
    private final int hopSize;
    private final int olaSize;
    private final int numHops;
    private final float shrink;
    private final boolean energyCorrection;
    private Cmplx[][] spectrums;
    private BooFFT fft;
    private final float[] synthesisWindow;
    private float[] invWindow;
    private float[] processBuffer;
    private float[] olaBuffer;
    private int olaIndex;

    public StftSynthesizerSingle(int blockSize0, int hopSize, int numHops, float[] modifiedWindow, float[] synthesisWindow, float shrink, boolean energyCorrection, StftAnalyzerSingle analyzer) {
        int blockSize;
        this.blockSize = blockSize = AudioMath.getCeilingPowerOf2((int)blockSize0);
        this.hopSize = hopSize;
        this.olaSize = blockSize - hopSize;
        this.numHops = numHops;
        this.shrink = shrink;
        this.energyCorrection = energyCorrection;
        this.synthesisWindow = synthesisWindow;
        this.fft = analyzer.getFFT();
        this.invWindow = new float[hopSize];
        boolean result = Windows.fillInverseWindow((float[])modifiedWindow, (float[])synthesisWindow, (float[])this.invWindow, (int)blockSize, (int)hopSize);
        if (!result) {
            Debug.warn((String)"Cannot create inverse window", (Object[])new Object[0]);
        }
        this.processBuffer = analyzer.getProcessBuffer();
        this.olaBuffer = new float[this.olaSize];
    }

    public void init() {
    }

    public void synthesize(Cmplx[][] spectrums, float[] output) {
        this.preSynthesize(spectrums, 0L);
        this.renderResult(output, 0L);
    }

    public void preSynthesize(Cmplx[][] spectrums, long clock) {
        this.spectrums = spectrums;
    }

    public void renderResult(float[] output, long clock) {
        int k = 0;
        while (k < this.numHops) {
            int offset = k * this.hopSize;
            this.backwardFFT(this.spectrums[k], this.processBuffer);
            this.applySynthesisWindow(this.processBuffer);
            int i = 0;
            while (i < this.hopSize) {
                output[i + offset] = (this.olaBuffer[(i + this.olaIndex) % this.olaSize] + this.processBuffer[i]) * this.invWindow[i];
                ++i;
            }
            this.olaIndex = (this.olaIndex + this.hopSize) % this.olaSize;
            i = 0;
            while (i < this.olaSize - this.hopSize) {
                int n = (i + this.olaIndex) % this.olaSize;
                this.olaBuffer[n] = this.olaBuffer[n] + this.processBuffer[i + this.hopSize];
                ++i;
            }
            i = this.olaSize - this.hopSize;
            while (i < this.olaSize) {
                this.olaBuffer[(i + this.olaIndex) % this.olaSize] = this.processBuffer[i + this.hopSize];
                ++i;
            }
            ++k;
        }
    }

    protected void backwardFFT(Cmplx[] spectrum, float[] output) {
        this.fft.backC2R(spectrum, output);
    }

    protected void applySynthesisWindow(float[] output) {
        block6: {
            block5: {
                if (!this.energyCorrection || this.shrink == 1.0f) break block5;
                float energyCorrection = 1.0f;
                float maxCorrection = (float)Math.sqrt(this.shrink);
                int blockSize = output.length;
                int cellSize = (int)((float)blockSize / this.shrink + 0.5f);
                int cellStart = (blockSize - cellSize) / 2;
                int cellStop = cellStart + cellSize;
                float cellEnergy = 0.0f;
                float blockEnergy = 0.0f;
                int i = 0;
                while (i < blockSize) {
                    float p = output[i] * output[i];
                    blockEnergy += p;
                    if (i >= cellStart && i < cellStop) {
                        cellEnergy += p;
                    }
                    ++i;
                }
                if (cellEnergy > 0.0f && (energyCorrection = (float)Math.sqrt(blockEnergy / cellEnergy)) > maxCorrection) {
                    energyCorrection = maxCorrection;
                }
                i = 0;
                while (i < output.length) {
                    int n = i;
                    output[n] = output[n] * (this.synthesisWindow[i] * energyCorrection);
                    ++i;
                }
                break block6;
            }
            if (this.synthesisWindow == null) break block6;
            int i = 0;
            while (i < output.length) {
                int n = i;
                output[n] = output[n] * this.synthesisWindow[i];
                ++i;
            }
        }
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public int getNumHops() {
        return this.numHops;
    }

    public int getOutputSize() {
        return this.hopSize * this.numHops;
    }

    public int getLatency() {
        return this.blockSize - this.hopSize;
    }

    public void setName(String name) {
    }

    public void createSerialSections(ISerialSectionFactory factory) {
    }

    public void setSerialSections(ISerialSectionPool pool) {
    }
}

