/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft;

class WindowSpec {
    private final int size;
    private final float shrink;
    private final boolean energyCorrection;

    public WindowSpec(int size, float shrink, boolean energyCorrection) {
        this.size = size;
        this.shrink = shrink;
        this.energyCorrection = energyCorrection;
    }

    public int getSize() {
        return this.size;
    }

    public float getShrink() {
        return this.shrink;
    }

    public boolean isEnergyCorrection() {
        return this.energyCorrection;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.energyCorrection ? 1231 : 1237);
        result = 31 * result + Float.floatToIntBits(this.shrink);
        result = 31 * result + this.size;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WindowSpec other = (WindowSpec)obj;
        if (this.energyCorrection != other.energyCorrection) {
            return false;
        }
        if (Float.floatToIntBits(this.shrink) != Float.floatToIntBits(other.shrink)) {
            return false;
        }
        return this.size == other.size;
    }

    public String toString() {
        return "WindowSpec [size=" + this.size + ", shrink=" + this.shrink + ", energyCorrection=" + this.energyCorrection + "]";
    }
}

